/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.po;

import java.util.Date;

import lombok.Data;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

/**
 * @title OrgStudentLesson
 * @desc 机构课节学生关联表
 * @author shanyu
 * @date 2015年10月12日
 * @version 1.0
 */

@Entity(dataSourceBeanName = "ttsDataSource")
@Table(name = "org_student_lesson", catalog = "tts")
@Data
public class OrgStudentLesson implements OrgResource {

    @Id
    @GeneratedValue
    private Long id;

    @Column
    private Long orgId;

    @Column
    private Long lessonId;

    @Column(name = "student_id")
    private Long userId;

    @Column
    private Long courseId;

    @Column
    private String studentName;

    @Column
    private String studentMobile;

    @Column
    private Date createTime;

    @Column
    private Date updateTime;

    @Column
    private Integer delStatus;

    @Column
    private Integer startStatus;

    @Column
    private Integer kexiaoStatus;//课消状态

    private OrgClassLesson lesson;

    @Override
    public Long getResourceId() {
        return this.userId;
    }

    @Override
    public String getResourceName() {
        return this.studentName;
    }

}
