
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;

import com.google.common.base.Function;

import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title OrgCourseConsumeRuleDaoImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年8月23日
 * @version 1.0
 */
@Repository
public class OrgCourseConsumeRuleDaoImpl extends JdbcTemplateDaoSupport<OrgCourseConsumeRule> implements OrgCourseConsumeRuleDao {

    @Override
    public List<OrgCourseConsumeRule> queryConsumRuleListByCourseIds(Long orgId,Collection<Long> courseIds, String...propes) {
        SingleSqlBuilder<OrgCourseConsumeRule> builder = createSqlBuilder(propes);
        builder.eq("orgId", orgId);
        builder.in("courseId", courseIds);
        return queryList(builder);

    }

    @Override
    public List<OrgCourseConsumeRule> queryConsumRuleListByUpdateTime(Date date) {
        SingleSqlBuilder<OrgCourseConsumeRule> builder = createSqlBuilder();
        builder.ge("updateTime",date);
        return queryList(builder);
    }

    @Override
    public Map<Long, Integer> queryCourseRuleMapByCourseIds(Long orgId,Collection<Long> courseIds) {
        
        List<OrgCourseConsumeRule> ruleList = this.queryConsumRuleListByCourseIds( orgId,courseIds);
        return CollectorUtil.collectMap(ruleList, new Function<OrgCourseConsumeRule, Long>() {
            @Override
            public Long apply(OrgCourseConsumeRule from) {
                return from.getCourseId();

            }
        }, new Function<OrgCourseConsumeRule, Integer>() {
            @Override
            public Integer apply(OrgCourseConsumeRule from) {
                return from.getRuleValue();

            }
        });
            
    }

    @Override
    public Integer getRuleValueByCourseId(Long orgId,Long courseId) {
        
        SingleSqlBuilder<OrgCourseConsumeRule> builder = createSqlBuilder("ruleValue");
        builder.eq("orgId", orgId);
        builder.eq("courseId", courseId);
        
        return this.queryForObject(builder, Integer.class);
            
    }
    
    @Override
    public OrgCourseConsumeRule getRuleByCourseId(Long orgId,Long courseId) {
        
        SingleSqlBuilder<OrgCourseConsumeRule> builder = createSqlBuilder("ruleValue");
        builder.eq("orgId", orgId);
        builder.eq("courseId", courseId);
        
        return this.uniqueResult(builder);
            
    }

    

   

}

    