/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.org.dto.StudentClasHourDocument;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.OrgStudentLessonCounter;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @author shanyu
 * @version 1.0
 * @title OrgStudentLessonDao
 * @desc TODO
 * @date 2015年10月12日
 */

public interface OrgStudentLessonDao extends CommonDao<OrgStudentLesson> {
    /**
     * 把学生从该学生未上课程中删除
     */
    void delStudentFromLesson(Long orgId, Collection<Long> lessonIds, Long userId);
    
    public int delStudentFromLesson(Long orgId, Collection<Long> lessonIds, Collection<Long> userIds);

    /**
     * @param orgId
     * @param lessonIds
     * @return
     */
    Map<Long, Integer> queryLessonStudentCountMap(Long orgId, Collection<Long> lessonIds);

    /**
     * @param orgId
     * @param lessonId
     * @return
     */
    Integer queryLessonStudentCount(Long orgId, Long lessonId);

    /**
     * 获取课节学生Id
     *
     * @param orgId
     * @param lessonIds
     * @return
     */
    List<Long> getUserIdsByLessonIds(Long orgId, Collection<Long> lessonIds);

    /**
     * @param orgId
     * @param
     * @return
     */
    Integer queryLessonStudentCount(Long orgId, Collection<Long> lessonId);

    /**
     * 获取学员课节安排
     *
     * @param orgId
     * @param lessonIds
     * @param userId
     * @return
     */
    List<Long> getLessIdsOfStudent(Long orgId, Collection<Long> lessonIds, Long userId);

    List<Long> getLessonIdsOfStudent(Long orgId, Long userId);

    Map<Long, List<Long>> getLessonIdsOfStudents(Long orgId, Collection<Long> userIds, Collection<Long> lessonIds);
    
    /**
     * 获取一个学员的所有的课节，不管删与不删
     *
     * @param orgId
     * @param lessonIds
     * @param userId
     * @return
     */
    List<OrgStudentLesson> getLessonsOfStudent(final Long orgId,final Long userId,
            final Collection<Long> lessonIds);

    //根据学生获取课程
    Map<Long, List<Long>> getStudentLessonList(Collection<Long> studentIds);

    /**
     * 获取课节学员id
     *
     * @param lessonId
     * @param orgId
     * @return
     */
    List<Long> getUserIds(Long lessonId, Long orgId);

    /**
     * 获取课节学生Id Map
     *
     * @param lessonIds
     * @param orgId
     * @return
     */
    Map<Long, List<Long>> getStudentCount(Collection<Long> lessonIds, Long orgId);

    /**
     * 获取课节学生id
     *
     * @param lessonIds
     * @return
     */
    Map<Long, List<Long>> getLessonStudentList(Collection<Long> lessonIds);

    Integer getStudentLessonCountToday(Long orgId, Long userId);
    
    public Integer getStudentLessonCountTodayByCourseId(Long orgId, Long userId,List<Long> courseIds);

    /**
     * 学生是否在课节中
     *
     * @param lessonId
     * @param userId
     * @return
     */
    boolean isStudentInlesson(Long lessonId, Long userId);

    Map<Long, Integer> getStudentLessonCountOfCourses(Long orgId, Long userId, Collection<Long> courseIds);

    /**
     * 老师学生数
     *
     * @param orgId
     * @param teacherIds
     * @param endTime
     * @return<老师－－学生数>
     */
    Map<Long, Integer> getStudentCountOfTeacher(Long orgId, Collection<Long> teacherIds, Date endTime);

    /**
     * 根据开始时间筛选学生课节信息
     *
     * @param startTime
     * @param endTime
     * @return Map<Long, List<Long>> 课节Id->学员userId
     */
    Map<Long, List<Long>> getStudentLessonByStartTime(Date startTime, Date endTime);

    /**
     * 根据结束时间筛选学生课节信息
     *
     * @param startTime
     * @param endTime
     * @return Map<Long, List<Long>> 课节Id->学员userId
     */
    Map<Long, List<Long>> getStudentLessonByEndTime(Date startTime, Date endTime);

    /**
     * 获取机构已结束课节学员数量
     *
     * @param orgId
     * @return
     */
    Integer getFinishLessonStudentCount(Long orgId);


    public List<OrgStudentLesson> queryStudentsByLessonId(Long orgId,Long lessonId);
    
    /**
     * 根据课节ids获取学生userIds
     */
    public List<OrgStudentLesson> getOrgStudentLessonsByLessonIds(Collection<Long> lessonIds);

    /**
     * 根据课程ID查找学员课节信息
     * @param courseId
     * @return
     */
    public List<OrgStudentLesson> getOrgStudentLessonsByCourseIds(Collection<Long> courseId);


    List<OrgStudentLesson> getStudentLessonsByPage(Date updateTime,PageDto pageDto);

    public void batchUpdateStatus(Collection<Long> ids, int status);

    public OrgStudentLessonCounter getStudentLessonCounter(long orgId,long userId,long courseId);

    public List<OrgStudentLessonCounter> getStudentLessonCounterList(long orgId,PageDto pageDto);
    
    /**
     * 默认按时间算课消时，计算学生剩余课节
     * @param orgId
     * @param courseId
     * @param userIds
     * @return
     */
    public Map<Long, Integer> getStudentsLeftLessonMap(Long orgId, Long courseId, Collection<Long> userIds);
    
    /**
     * 批量查询学生某个课程的课节
     * @param orgId
     * @param courseId
     * @param userIds
     * @return
     */
    public Map<Long, List<Long>> getStudentCourseLessonMap(Long orgId, Long courseId, Collection<Long> userIds);

    public void batchUpdateKexiaoStatus(Collection<Long> lessonIds, int status);

    public void batchUpdateKexiaoStatusBySign(List<OrgLessonSign> signs, int status);
    
    public List<OrgStudentLesson> getLessonStudentListDelStatus(Collection<Long> lessonIds);
    
    
    public List<StudentClasHourDocument> queryStudentClassHours(Set<Long> studentIds, Long orgId);

}
