package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author zhangrui
 * @version 1.0
 * @title OrgLessonConflictDao
 * @desc TODO
 */

public interface OrgLessonConflictDao extends CommonDao<OrgLessonConflict> {

    public boolean updateLessonConflictByCondition(Long orgId,Map<String,Object> fileds,Map<String,Object> condition);

    List<OrgLessonConflict> queryTeacherLessonConflict(Long orgId,Long teacherId, Date startTime, Date endTime,Long lessonId, PageDto pageDto);


    /**
     * 查询有冲突的课节
     * @param orgId：机构id
     * @param teacherIds：老师id集合
     * @param courseIds：教室集合id
     * @return
     */
	public List<OrgLessonConflict> queryConfilctByTeacherIds(Long orgId, List<Long> teacherIds);

	/**
	 * 查询冲突课节
	 * @param orgId：机构id
	 * @param classRoomIds：教室id集合
	 * @param courseIds：课程id集合
	 * @return
	 */
	public List<OrgLessonConflict> queryConfilctByClassRoomIds(Long orgId, List<Long> classRoomIds);
	
	 /**
     * 根据老师ids查询时间区间内的所有课节
     * @param orgId：机构id
     * @param teacherIds：老师id集合
     * @param startTime：时间区间开始时间
     * @param endTime：时间区间结束时间
     * @return
     */
    public Map<Long,List<OrgLessonConflict>> queryConfilctByTeacherIdsAndTimeRange(Long orgId, Collection<Long> teacherIds,Date startTime,Date endTime);

    /**
     * 根据教室ids查询时间区间内的所有课节
     * @param orgId：机构id
     * @param classRoomIds：教室id集合
     * @param startTime：时间区间开始时间
     * @param endTime：时间区间结束时间
     * @return
     */
    public Map<Long,List<OrgLessonConflict>> queryConfilctByClassRoomIdsAndTimeRange(Long orgId, Collection<Long> classRoomIds,Date startTime,Date endTime);

    List<OrgLessonConflict> queryRoomLessonConflict(Long orgId,Long roomId, Date startTime, Date endTime,Long lessonId, PageDto pageDto);

    int queryTeacherConflictNum(Long orgId,Long teacherId, Date startTime, Date endTime,Long lessonId);

    int queryRoomConflictNum(Long orgId,Long roomId, Date startTime, Date endTime,Long lessonId);

	void updateDelStatus(Set<Object> id);

	void saveOrgLessonConflicts(List<OrgLessonConflict> lists);
}
