/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgLessonConflictDao;
import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.bean.SQLOperator;
import com.baijia.tianxiao.sqlbuilder.bean.impl.AndExp;
import com.baijia.tianxiao.sqlbuilder.bean.impl.GeExp;
import com.baijia.tianxiao.sqlbuilder.bean.impl.GtExp;
import com.baijia.tianxiao.sqlbuilder.bean.impl.LeExp;
import com.baijia.tianxiao.sqlbuilder.bean.impl.LtExp;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrgLessonConflictDaoImpl
extends JdbcTemplateDaoSupport<OrgLessonConflict>
implements OrgLessonConflictDao {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonConflictDaoImpl.class);
    private static final String update = "update tts.org_lesson_conflict set ";
    private static final String count = "select count(id) from tts.org_lesson_conflict where ";
    private static final String insert = "insert into tts.org_lesson_conflict (org_id,lesson_id,teacher_id,room_id,start_time,end_time,del_status) values (:orgId,:lessonId,:teacherId,:roomId,:startTime,:endTime,:delStatus)";

    @Override
    public boolean updateLessonConflictByCondition(Long orgId, Map<String, Object> fileds, Map<String, Object> condition) {
        StringBuilder sb = new StringBuilder(update);
        Map params = Maps.newHashMap();
        if (fileds.size() > 0) {
            for (Map.Entry<String, Object> entry : fileds.entrySet()) {
                sb.append(String.valueOf(entry.getKey()) + " = :" + entry.getKey() + ",");
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u9700\u8981\u4f20\u5165\u66f4\u65b0\u7684\u5b57\u6bb5");
        }
        sb.deleteCharAt(sb.length() - 1);
        params.putAll(fileds);
        if (condition.size() > 0) {
            sb.append(" where ");
            int index = 0;
            for (Map.Entry<String, Object> entry : condition.entrySet()) {
                String conditionField = String.valueOf(entry.getKey()) + "_" + index;
                sb.append(String.valueOf(entry.getKey()) + " = :" + conditionField + " and ");
                ++index;
                params.put(conditionField, entry.getValue());
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u9700\u8981\u4f20\u5165\u6761\u4ef6\u5b57\u6bb5");
        }
        sb.delete(sb.length() - 4, sb.length());
        log.info("updateLessonConflictByCondition sql:" + sb.toString() + ", params:" + params);
        return this.getNamedJdbcTemplate().update(sb.toString(), params) > 0;
    }

    @Override
    public List<OrgLessonConflict> queryTeacherLessonConflict(Long orgId, Long teacherId, Date startTime, Date endTime, Long lessonId, PageDto pageDto) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.eq("org_id", (Serializable)orgId);
        sqlBuilder.eq("teacher_id", (Serializable)teacherId);
        GeExp startGe = new GeExp("start_time", (Object)startTime, SQLOperator.GE);
        LtExp startLt = new LtExp("start_time", (Object)endTime, SQLOperator.LT);
        GtExp endGt = new GtExp("end_time", (Object)startTime, SQLOperator.GT);
        LeExp endLe = new LeExp("end_time", (Object)endTime, SQLOperator.LE);
        LtExp startLtStartTime = new LtExp("start_time", (Object)startTime, SQLOperator.LT);
        GtExp endGtEndTime = new GtExp("end_time", (Object)endTime, SQLOperator.GT);
        AndExp startAndExp = new AndExp((Expression)startGe, (Expression)startLt);
        AndExp endAndExp = new AndExp((Expression)endGt, (Expression)endLe);
        AndExp startEnd = new AndExp((Expression)startLtStartTime, (Expression)endGtEndTime);
        sqlBuilder.or(new Expression[]{startAndExp, endAndExp, startEnd});
        sqlBuilder.eq("del_status", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        if (lessonId != null && lessonId > 0L) {
            sqlBuilder.ne("lesson_id", (Serializable)lessonId);
        }
        sqlBuilder.setOrder(Order.asc((String[])new String[]{"start_time"}));
        sqlBuilder.setPage(pageDto);
        return this.queryList(sqlBuilder);
    }

    @Override
    public List<OrgLessonConflict> queryRoomLessonConflict(Long orgId, Long roomId, Date startTime, Date endTime, Long lessonId, PageDto pageDto) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.eq("org_id", (Serializable)orgId);
        sqlBuilder.eq("room_id", (Serializable)roomId);
        GeExp startGe = new GeExp("start_time", (Object)startTime, SQLOperator.GE);
        LtExp startLt = new LtExp("start_time", (Object)endTime, SQLOperator.LT);
        GtExp endGt = new GtExp("end_time", (Object)startTime, SQLOperator.GT);
        LeExp endLe = new LeExp("end_time", (Object)endTime, SQLOperator.LE);
        LtExp startLtStartTime = new LtExp("start_time", (Object)startTime, SQLOperator.LT);
        GtExp endGtEndTime = new GtExp("end_time", (Object)endTime, SQLOperator.GT);
        AndExp startAndExp = new AndExp((Expression)startGe, (Expression)startLt);
        AndExp endAndExp = new AndExp((Expression)endGt, (Expression)endLe);
        AndExp startEnd = new AndExp((Expression)startLtStartTime, (Expression)endGtEndTime);
        sqlBuilder.or(new Expression[]{startAndExp, endAndExp, startEnd});
        sqlBuilder.eq("del_status", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        if (lessonId != null && lessonId > 0L) {
            sqlBuilder.ne("lesson_id", (Serializable)lessonId);
        }
        sqlBuilder.setOrder(Order.asc((String[])new String[]{"start_time"}));
        sqlBuilder.setPage(pageDto);
        return this.queryList(sqlBuilder);
    }

    @Override
    public List<OrgLessonConflict> queryConfilctByTeacherIds(Long orgId, List<Long> teacherIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("org_id", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            builder.in("teacher_id", teacherIds);
        }
        builder.eq("del_status", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonConflict> queryConfilctByClassRoomIds(Long orgId, List<Long> classRoomIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("org_id", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(classRoomIds)) {
            builder.in("room_id", classRoomIds);
        }
        builder.eq("del_status", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public int queryTeacherConflictNum(Long orgId, Long teacherId, Date startTime, Date endTime, Long lessonId) {
        StringBuilder sb = new StringBuilder(count);
        sb.append(" org_id=:orgId and teacher_id=:teacherId and ((start_time >= :startTime and start_time < :endTime) or (end_time > :startTime and end_time <= :endTime) or (start_time < :startTime and end_time > :endTime)) and del_status=" + DataStatus.NORMAL.getValue());
        Map params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("teacherId", teacherId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        if (lessonId != null && lessonId > 0L) {
            sb.append(" and lesson_id != :lessonId ");
            params.put("lessonId", lessonId);
        }
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sb.toString(), params, Integer.class);
    }

    @Override
    public int queryRoomConflictNum(Long orgId, Long roomId, Date startTime, Date endTime, Long lessonId) {
        StringBuilder sb = new StringBuilder(count);
        sb.append(" org_id=:orgId and room_id=:roomId and ((start_time >= :startTime and start_time < :endTime) or (end_time > :startTime and end_time <= :endTime) or (start_time < :startTime and end_time > :endTime)) and del_status=" + DataStatus.NORMAL.getValue());
        Map params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("roomId", roomId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        if (lessonId != null && lessonId > 0L) {
            sb.append(" and lesson_id != :lessonId ");
            params.put("lessonId", lessonId);
        }
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sb.toString(), params, Integer.class);
    }

    @Override
    public void updateDelStatus(Set<Object> id) {
        StringBuilder sb = new StringBuilder(update);
        sb.append(" del_status = :delStatus where lesson_id in (:lessonIds)");
        Map params = Maps.newHashMap();
        params.put("delStatus", DataStatus.DELETE.getValue());
        params.put("lessonIds", id);
        this.getNamedJdbcTemplate().update(sb.toString(), params);
    }

    @Override
    public void saveOrgLessonConflicts(List<OrgLessonConflict> lists) {
        StringBuilder sb = new StringBuilder(insert);
        List list = null;
        int index = 0;
        int i = 0;
        for (OrgLessonConflict conflict : lists) {
            if (i == 0) {
                list = Lists.newArrayList();
            }
            Map params = Maps.newHashMap();
            params.put("orgId", conflict.getOrgId());
            params.put("teacherId", conflict.getTeacherId() == null ? 0L : conflict.getTeacherId());
            params.put("roomId", conflict.getRoomId() == null ? 0L : conflict.getRoomId());
            params.put("lessonId", conflict.getLessonId());
            params.put("startTime", conflict.getStartTime());
            params.put("endTime", conflict.getEndTime());
            params.put("delStatus", conflict.getDelStatus() == null ? 0 : conflict.getDelStatus());
            list.add(params);
            if (++i != 10000 && ++index != lists.size()) continue;
            Map[] map = new Map[list.size()];
            this.getNamedJdbcTemplate().batchUpdate(insert, list.toArray(map));
            i = 0;
        }
    }

    @Override
    public Map<Long, List<OrgLessonConflict>> queryConfilctByTeacherIdsAndTimeRange(Long orgId, Collection<Long> teacherIds, Date startTime, Date endTime) {
        Map teacherConflictMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(teacherIds)) {
            return teacherConflictMap;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.in("teacherId", teacherIds);
        builder.between("startTime", (Comparable)startTime, (Comparable)endTime);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        List list = this.queryList(builder);
        for (OrgLessonConflict conflict : list) {
            Long teacherId = conflict.getTeacherId();
            List tempList = (List)teacherConflictMap.get(teacherId);
            if (tempList == null) {
                tempList = Lists.newArrayList();
                teacherConflictMap.put(teacherId, tempList);
            }
            tempList.add(conflict);
        }
        return teacherConflictMap;
    }

    @Override
    public Map<Long, List<OrgLessonConflict>> queryConfilctByClassRoomIdsAndTimeRange(Long orgId, Collection<Long> classRoomIds, Date startTime, Date endTime) {
        Map roomConflictMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(classRoomIds)) {
            return roomConflictMap;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.in("roomId", classRoomIds);
        builder.between("startTime", (Comparable)startTime, (Comparable)endTime);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        List list = this.queryList(builder);
        for (OrgLessonConflict conflict : list) {
            Long roomId = conflict.getRoomId();
            List tempList = (List)roomConflictMap.get(roomId);
            if (tempList == null) {
                tempList = Lists.newArrayList();
                roomConflictMap.put(roomId, tempList);
            }
            tempList.add(conflict);
        }
        return roomConflictMap;
    }
}

