package com.baijia.tianxiao.dal.org.po;

import java.util.Date;

import lombok.Data;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

/**
 * 课节签到
 * 
 * @title OrgLessonSign
 * @desc TODO
 * @author shizuwei
 * @date 2015年12月26日
 * @version 1.0
 */
@Entity(dataSourceBeanName = "ttsDataSource")
@Table(name = "org_lesson_sign", catalog = "tts")
@Data
public class OrgLessonSign {

    @Id
    @GeneratedValue
    private Long id;
    @Column
    private Long orgId;
    @Column
    private Long courseId;
    @Column
    private Long lessonId;
    @Column
    private Long userId;// 签到用户id
    @Column
    private Integer userRole;// 用户角色: 2 学生,0，老师
    @Column
    private Integer status = 0;// 0,未签到；1，签到；2，请假；3，旷课
    @Column
    private Date createTime;
    @Column
    private Date updateTime;

    // 课节编号，取自tts.org_class_lesson
    private Integer index;
    
    private String randomUUID;

}
