/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxLiveRoomDao;
import com.baijia.tianxiao.dal.org.dto.WxLiveRoomQueryDto;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class WxLiveRoomDaoImpl
extends JdbcTemplateDaoSupport<WxLiveRoom>
implements WxLiveRoomDao {
    @Override
    public List<WxLiveRoom> queryByConditon(WxLiveRoomQueryDto dto, PageDto pageDto) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        if (dto.getOrgId() != null) {
            sqlBuilder.eq("orgId", (Serializable)dto.getOrgId());
        }
        if (dto.getCourseId() != null) {
            sqlBuilder.eq("courseId", (Serializable)dto.getCourseId());
        }
        if (dto.getLessonId() != null) {
            sqlBuilder.eq("lessonId", (Serializable)dto.getLessonId());
        }
        if (dto.getStartTimeStart() != null) {
            sqlBuilder.ge("startTime", (Serializable)dto.getStartTimeStart());
        }
        if (dto.getStartTimeEnd() != null) {
            sqlBuilder.le("startTime", (Serializable)dto.getStartTimeEnd());
        }
        if (dto.getEndTimeStart() != null) {
            sqlBuilder.ge("endTime", (Serializable)dto.getEndTimeStart());
        }
        if (dto.getEndTimeEnd() != null) {
            sqlBuilder.le("endTime", (Serializable)dto.getEndTimeEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTitle())) {
            sqlBuilder.like("title", (Serializable)((Object)dto.getTitle()), MatchMode.ANYWHERE);
        }
        if (dto.getRoomId() != null) {
            sqlBuilder.eq("roomId", (Serializable)dto.getRoomId());
        }
        if (dto.getPlayBack() != null) {
            sqlBuilder.eq("playBack", (Serializable)dto.getPlayBack());
        }
        sqlBuilder.desc("startTime");
        sqlBuilder.setPage(pageDto);
        return this.queryList(sqlBuilder);
    }

    @Override
    public List<WxLiveRoom> queryActiveLiveRoomList() {
        Date now = new Date();
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.le("enterTime", (Serializable)now);
        sqlBuilder.ge("endTime", (Serializable)now);
        return this.queryList(sqlBuilder);
    }

    @Override
    public WxLiveRoom getByRoomId(Long roomId) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.eq("roomId", (Serializable)roomId);
        return (WxLiveRoom)this.uniqueResult(sqlBuilder);
    }
}

