/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgTeacherLessonDaoImpl
extends JdbcTemplateDaoSupport<OrgTeacherLesson>
implements OrgTeacherLessonDao {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherLessonDaoImpl.class);

    public OrgTeacherLessonDaoImpl() {
        super(OrgTeacherLesson.class);
    }

    @Override
    public List<OrgTeacherLesson> queryTeacherLessons(Long orgId, Collection<Long> teacherIds, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            builder.in("teacherId", teacherIds);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacherLesson> queryTeacherLessonsByLessonIds(String query, Long orgId, Collection<Long> lessonIds, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            builder.like("teacherName", (Serializable)((Object)query), MatchMode.ANYWHERE);
        }
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Long> queryLessonTeacherIdMap(final Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Long>>(){

            public Map<Long, Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgTeacherLessonDaoImpl.this.createSqlBuilder(new String[0]);
                builder.select("teacherId");
                builder.select("lessonId");
                if (orgId != null) {
                    builder.eq("orgId", (Serializable)orgId);
                }
                builder.in("lessonId", querySet);
                builder.group("lessonId");
                final HashMap result = Maps.newHashMap();
                log.debug("query lessonTeacher id map sql:{}, params:{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
                OrgTeacherLessonDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("lessonId"), rs.getLong("teacherId"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<Long> getUserIds(Long lessonId, Long orgId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("teacherId");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("lessonId", (Serializable)lessonId);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> queryTeacherLessons(Long orgId, Long teacherId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("teacherId", (Serializable)teacherId);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public boolean isTeacherInLesson(Long lessonId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("teacherId", (Serializable)userId);
        List list = this.queryForList(builder, Long.class);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public OrgTeacherLesson getByLessonId(Long orgId, Long lessonId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        List list = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (OrgTeacherLesson)list.get(0);
        }
        return null;
    }

    @Override
    public Map<Long, List<Long>> getTeacherLessonByStartTime(Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select teacher.lesson_id as lessonId, teacher.teacher_id as teacherId from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("teacherId");
                Long lessonId = rs.getLong("lessonId");
                if (!result.containsKey(userId)) {
                    result.put(userId, Lists.newArrayList());
                }
                ((List)result.get(userId)).add(lessonId);
            }
        });
        return result;
    }

    @Override
    public Map<Long, List<Long>> getTeacherLessonByEndTime(Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select teacher.lesson_id as lessonId, teacher.teacher_id as teacherId from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.end_time >=:startTime and lesson.end_time <:endTime");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("teacherId");
                Long lessonId = rs.getLong("lessonId");
                if (!result.containsKey(lessonId)) {
                    result.put(lessonId, Lists.newArrayList());
                }
                ((List)result.get(lessonId)).add(userId);
            }
        });
        return result;
    }

    @Override
    public int countTeacherLessonByMonth(Long teacherUserId, Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(1) from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.end_time <:endTime and teacher.teacher_id = :teacherId");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        param.put("teacherId", teacherUserId);
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sb.toString(), (Map)param, Integer.class);
    }

    @Override
    public Map<Long, OrgTeacherLesson> getOrgTeacherLessonMapByLessonIds(Collection<Long> lessonIds) {
        if (lessonIds.isEmpty()) {
            log.warn("lesson ids is empty.");
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List orgTeacherLessons = (List)queryTemplate.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgTeacherLesson>>(){

            public List<OrgTeacherLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgTeacherLessonDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("lessonId", querySet);
                return OrgTeacherLessonDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.collectMap((Collection)orgTeacherLessons, (Function)new Function<OrgTeacherLesson, Long>(){

            public Long apply(OrgTeacherLesson arg0) {
                return arg0.getLessonId();
            }
        });
    }

    @Override
    public List<OrgTeacherLesson> queryByLessonIds(Long orgId, Collection<Long> classLessonIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(classLessonIds)) {
            builder.in("lessonId", classLessonIds);
        }
        return this.queryList(builder);
    }

    @Override
    public Map<Long, List<Long>> getTeacherLessonByStartTime(Date startTime, Date endTime, Collection<Long> teacherUserIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("select teacher.lesson_id as lessonId, teacher.teacher_id as teacherId from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime and lesson.del_status=0");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        if (CollectionUtils.isNotEmpty(teacherUserIds)) {
            sb.append(" and teacher.teacher_id IN (:teacherUserIds)");
            param.put("teacherUserIds", teacherUserIds);
        }
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("teacherId");
                Long lessonId = rs.getLong("lessonId");
                if (!result.containsKey(userId)) {
                    result.put(userId, Lists.newArrayList());
                }
                ((List)result.get(userId)).add(lessonId);
            }
        });
        return result;
    }

    @Override
    public List<Long> getTeacherLessonIdsByStartTime(Date startTime, Date endTime, Long teacherUserId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select teacher.lesson_id as lessonId from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime and lesson.del_status=0");
        sb.append(" and teacher.teacher_id =:teacherUserId");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        param.put("teacherUserId", teacherUserId);
        final ArrayList<Long> result = new ArrayList<Long>();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long lessonId = rs.getLong("lessonId");
                result.add(lessonId);
            }
        });
        return result;
    }

    @Override
    public Map<Long, Map<Long, List<Long>>> getTeacherCourseLessonBy(Date startTime, Date endTime, Collection<Long> teacherUserIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("select teacher.teacher_id, teacher.lesson_id, lesson.course_id from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime and lesson.del_status=0");
        sb.append(" and teacher.teacher_id IN (:teacherUserIds)");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        param.put("teacherUserIds", teacherUserIds);
        final HashMap<Long, Map<Long, List<Long>>> result = new HashMap<Long, Map<Long, List<Long>>>();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long teacherId = rs.getLong("teacher_id");
                Long courseId = rs.getLong("course_id");
                Long lessonId = rs.getLong("lesson_id");
                HashMap<Long, ArrayList<Long>> teacherCourseMap = null;
                ArrayList<Long> lessonIds = null;
                teacherCourseMap = (HashMap<Long, ArrayList<Long>>)result.get(teacherId);
                if (teacherCourseMap == null) {
                    teacherCourseMap = new HashMap<Long, ArrayList<Long>>();
                    result.put(teacherId, teacherCourseMap);
                }
                if ((lessonIds = (ArrayList<Long>)teacherCourseMap.get(courseId)) == null) {
                    lessonIds = new ArrayList<Long>();
                    teacherCourseMap.put(courseId, lessonIds);
                }
                lessonIds.add(lessonId);
            }
        });
        return result;
    }

    @Override
    public Map<Long, Integer> mapDisticntTeacherCountByCourse(Date startTime, Date endTime, Collection<Long> teacherUserIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("select lesson.course_id, count(distinct(teacher.teacher_id)) as teacher_count from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime and lesson.del_status=0");
        sb.append(" and teacher.teacher_id IN (:teacherUserIds)");
        sb.append(" group by lesson.course_id");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        param.put("teacherUserIds", teacherUserIds);
        final HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long courseId = rs.getLong("course_id");
                Integer teacherCount = rs.getInt("teacher_count");
                result.put(courseId, teacherCount);
            }
        });
        return result;
    }

    @Override
    public Integer countClassId(Date startTime, Date endTime, Long teacherUserId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(distinct(lesson.course_id)) from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime and lesson.del_status=0");
        sb.append(" and teacher.teacher_id =:teacherUserId");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        param.put("teacherUserId", teacherUserId);
        Integer count = this.getNamedJdbcTemplate().queryForInt(sb.toString(), (Map)param);
        return count != null ? count : 0;
    }

    @Override
    public List<Long> listClassId(Date startTime, Date endTime, Long teacherUserId, PageDto pageDto) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct(lesson.course_id) as course_id from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime and lesson.del_status=0");
        sb.append(" and teacher.teacher_id =:teacherUserId");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        param.put("teacherUserId", teacherUserId);
        if (pageDto != null) {
            sb.append(" limit :start,:size");
            param.put("start", (pageDto.getPageNum() - 1) * pageDto.getPageSize());
            param.put("size", pageDto.getPageSize());
        }
        final ArrayList<Long> result = new ArrayList<Long>();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                result.add(rs.getLong("course_id"));
            }
        });
        return result;
    }

    @Override
    public List<Long> listLessonId(Collection<Long> lessonIds, Long teacherUserId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("lessonId");
        builder.in("lessonId", lessonIds);
        builder.eq("teacherId", (Serializable)teacherUserId);
        return this.queryList(builder, Long.class);
    }
}

