/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseSmsDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseSms>
implements OrgCourseSmsDao {
    public OrgCourseSmsDaoImpl() {
        super(OrgCourseSms.class);
    }

    @Override
    public List<OrgCourseSms> getOrgCourseSmsList(Long orgId, Long courseId, Integer userRole, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        if (userRole != null) {
            builder.eq("userRole", (Serializable)userRole);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourseSms> getOrgCourseSmsList(final Long orgId, Collection<Long> courseIds, final Integer userRole, final String ... queryProps) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgCourseSms>>(){

            public List<OrgCourseSms> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseSmsDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                builder.in("courseId", querySet);
                if (userRole != null) {
                    builder.eq("userRole", (Serializable)userRole);
                }
                return OrgCourseSmsDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public OrgCourseSms getOrgCourseSms(Long orgId, Long courseId, Integer userRole, Long userId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("userRole", (Serializable)userRole);
        builder.eq("userId", (Serializable)userId);
        return (OrgCourseSms)this.uniqueResult(builder);
    }

    @Override
    public void increaseSendTime(Long orgId, Long courseId, Integer userRole, Long userId) {
        OrgCourseSms sms = this.getOrgCourseSms(orgId, courseId, userRole, userId, new String[0]);
        if (sms != null) {
            sms.setSend(sms.getSend() == null ? 1 : sms.getSend() + 1);
        }
        this.update(sms, new String[]{"send"});
    }

    @Override
    public void setViewStatus(Long id, Integer viewStatus) {
        OrgCourseSms sms = (OrgCourseSms)this.getById(id, new String[]{"id", "viewStatus"});
        if (sms != null) {
            sms.setViewStatus(viewStatus);
        }
        this.update(sms, new String[]{"send"});
    }

    @Override
    public void delCourseSmsRecord(Long orgId, Long courseId, Integer userRole, Collection<Long> userIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((userRole != null ? 1 : 0) != 0, (Object)"userRole is illegal");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(userIds), (Object)"userId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("userRole", (Serializable)userRole);
        builder.in("userId", userIds);
        this.delete(builder);
    }

    @Override
    public Map<Long, Integer> courseSmsTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from tts.org_course_sms where org_id in (:orgIds)";
        if (startTime != null && endTime != null) {
            sql = String.valueOf(sql) + " and create_time between :startTime and :endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql = String.valueOf(sql) + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }
}

