/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseSeatDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseSeat;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseSeatDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseSeat>
implements OrgCourseSeatDao {
    public OrgCourseSeatDaoImpl() {
        super(OrgCourseSeat.class);
    }

    @Override
    public List<OrgCourseSeat> getSeatsByCourseId(Long courseId, String ... propes) {
        SingleSqlBuilder builder = this.createSqlBuilder(propes);
        builder.eq("courseId", (Serializable)courseId);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getSeatMap(Long courseId) {
        List<OrgCourseSeat> list = this.getSeatsByCourseId(courseId, "userId", "seatId");
        return CollectorUtil.collectMap(list, (Function)new Function<OrgCourseSeat, Long>(){

            public Long apply(OrgCourseSeat from) {
                return from.getUserId();
            }
        }, (Function)new Function<OrgCourseSeat, Integer>(){

            public Integer apply(OrgCourseSeat from) {
                return from.getSeatId();
            }
        });
    }

    @Override
    public List<Long> getSeatInfoIdsByCourseId(Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("courseId", (Serializable)courseId);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> getSeatInfoIds(final Long courseId, Collection<Long> userIds) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseSeatDaoImpl.this.createSqlBuilder(new String[]{"id"});
                builder.eq("courseId", (Serializable)courseId);
                builder.in("userId", querySet);
                return OrgCourseSeatDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public Map<Long, Integer> getSeatInfoIds(Collection<Long> courseIds, final Long userId) {
        MapBatchQueryTemplate batchQueryTemplate = new MapBatchQueryTemplate();
        return (Map)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseSeatDaoImpl.this.createSqlBuilder(new String[0]);
                builder.count("id");
                builder.select("userId");
                builder.in("courseId", querySet);
                builder.eq("userId", (Serializable)userId);
                builder.group("courseId");
                List queryRes = OrgCourseSeatDaoImpl.this.query2ListMap(builder);
                HashMap result = Maps.newHashMap();
                for (Map res : queryRes) {
                    result.put(((Number)res.get("courseId")).longValue(), ((Number)res.get("cnt_id")).intValue());
                }
                return result;
            }
        });
    }

    @Override
    public Integer getSeatCountByLayoutId(Long layoutId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("layoutId", (Serializable)layoutId);
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public boolean isSeatUsed(Long courseId, Long layoutId, Integer seatNo) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("layoutId", (Serializable)layoutId);
        builder.eq("seatId", (Serializable)seatNo);
        List list = this.queryList(builder);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public OrgCourseSeat getCourseSeat(Long courseId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("userId", (Serializable)userId);
        return (OrgCourseSeat)this.uniqueResult(builder);
    }
}

