/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupStorageDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupStorage;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSignupStorageDaoImpl
extends JdbcTemplateDaoSupport<OrgSignupStorage>
implements OrgSignupStorageDao {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupStorageDaoImpl.class);

    public OrgSignupStorageDaoImpl() {
        super(OrgSignupStorage.class);
    }

    @Override
    public void addOrEditOrgSignupStorage(Long orgId, Collection<OrgSignupStorage> orgSignupStorages) {
        for (OrgSignupStorage orgSignupStorage : orgSignupStorages) {
            if (orgSignupStorage.getOrgId() != null) continue;
            orgSignupStorage.setOrgId(orgId);
        }
        log.debug("orgId = {}, orgSignupStorages = {} size = {}", new Object[]{orgId, orgSignupStorages, orgSignupStorages.size()});
        for (OrgSignupStorage signup : orgSignupStorages) {
            List<OrgSignupStorage> temp = this.getOrgSignupStorage(signup);
            if (CollectionUtils.isNotEmpty(temp)) {
                OrgSignupStorage old = temp.get(0);
                old.setRemark(signup.getRemark());
                this.update(old, new String[0]);
                continue;
            }
            this.save(signup, new String[0]);
        }
    }

    @Override
    public void delOrgSignupStorage(Collection<OrgSignupStorage> orgSignupStorages) throws Exception {
        for (OrgSignupStorage orgSignupStorage : orgSignupStorages) {
            List<OrgSignupStorage> temp = this.getOrgSignupStorage(orgSignupStorage);
            if (CollectionUtils.isNotEmpty(temp)) {
                if (temp.size() == 1) {
                    OrgSignupStorage old = temp.get(0);
                    this.delById(old.getId());
                    continue;
                }
                log.error("{} : {}", orgSignupStorages, temp);
                continue;
            }
            throw new Exception("\u5220\u9664\u5931\u8d25!");
        }
    }

    private List<OrgSignupStorage> getOrgSignupStorage(OrgSignupStorage signup) {
        if (signup.getId() == null) {
            SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
            sqlBuilder.eq("orgId", (Serializable)signup.getOrgId());
            sqlBuilder.eq("signupPurchaseId", (Serializable)signup.getSignupPurchaseId());
            sqlBuilder.eq("storageId", (Serializable)signup.getStorageId());
            return this.queryList(sqlBuilder);
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.getById(signup.getId(), new String[0]));
        return list;
    }

    @Override
    public List<OrgSignupStorage> getOrgSignupStorageBySignupPurchaseId(Long orgId, Long signupPurchaseId) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.eq("orgId", (Serializable)orgId);
        sqlBuilder.eq("signupPurchaseId", (Serializable)signupPurchaseId);
        List list = this.queryList(sqlBuilder);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 1) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (((OrgSignupStorage)it.next()).getStorageId() != 0L) continue;
                it.remove();
            }
        }
        log.debug("list = {}", (Object)list);
        return list;
    }
}

