/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgClassRoomDaoImpl
extends JdbcTemplateDaoSupport<OrgClassRoom>
implements OrgClassRoomDao {
    public OrgClassRoomDaoImpl() {
        super(OrgClassRoom.class);
    }

    @Override
    public List<OrgClassRoom> getClassRoom(Long orgId, Long branchId, Boolean isDel, PageDto page, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgid is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (branchId != null) {
            builder.eq("branchId", (Serializable)branchId);
        }
        if (isDel != null) {
            builder.eq("delStatus", (Serializable)isDel);
        }
        builder.desc("createTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, String> getRoomName(final Long orgId, Collection<Long> roomIds) {
        if (CollectionUtils.isEmpty(roomIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(roomIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, String>>(){

            public Map<Long, String> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassRoomDaoImpl.this.createSqlBuilder(new String[]{"roomName", "id"});
                if (orgId != null) {
                    builder.eq("orgId", (Serializable)orgId);
                }
                builder.in("id", querySet);
                final HashMap result = Maps.newHashMap();
                OrgClassRoomDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("id"), rs.getString("roomName"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public void refreshClassRoom(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update tts.org_class_room set del_status =1 where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }
}

