/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.po.ClassHour;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgClassLessonDaoImpl
extends JdbcTemplateDaoSupport<OrgClassLesson>
implements OrgClassLessonDao {
    private static final Logger log = LoggerFactory.getLogger(OrgClassLessonDaoImpl.class);

    public OrgClassLessonDaoImpl() {
        super(OrgClassLesson.class);
    }

    @Override
    public List<OrgClassLesson> queryLessons(Long orgId, Collection<Long> courseIds, Collection<Long> roomIds, Collection<Long> lessonIds, Date startTime, Date endTime, PageDto page, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("courseId", courseIds);
        }
        if (CollectionUtils.isNotEmpty(roomIds)) {
            builder.in("roomId", roomIds);
        }
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("id", lessonIds);
        }
        builder.asc("startTime");
        if (startTime != null) {
            builder.gt("startTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.desc("startTime");
            builder.lt("startTime", (Serializable)endTime);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getLessonTimemap(Collection<Long> courseIds, Date date, Long orgId, Integer delStatus) {
        List<OrgClassLesson> lessons = this.getLessons(courseIds, date, orgId, delStatus, "courseId");
        if (CollectionUtils.isEmpty(lessons)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrgClassLesson orgClassLesson : lessons) {
            if (!map.containsKey(orgClassLesson.getCourseId())) {
                map.put(orgClassLesson.getCourseId(), 0);
            }
            map.put(orgClassLesson.getCourseId(), (Integer)map.get(orgClassLesson.getCourseId()) + 1);
        }
        return map;
    }

    @Override
    public List<OrgClassLesson> getLessons(Collection<Long> courseIds, final Date date, final Long orgId, final Integer delStatus, final String ... queryProps) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgClassLesson>>(){

            public List<OrgClassLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)delStatus);
                builder.in("courseId", querySet);
                if (date != null) {
                    builder.le("endTime", (Serializable)date);
                }
                return OrgClassLessonDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgClassLesson> getLessons(Collection<Long> courseIds, final Date startTime, final Date endTime, PageDto pageDto) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgClassLesson>>(){

            public List<OrgClassLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("courseId", querySet);
                if (startTime != null) {
                    builder.ge("startTime", (Serializable)startTime);
                }
                if (endTime != null) {
                    builder.lt("startTime", (Serializable)endTime);
                }
                return OrgClassLessonDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<Long> getLeftLessonIds(Long orgId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        builder.ge("startTime", (Serializable)new Date());
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Integer getLessonCountOfStudent(Long orgId, Long courseId, Long studentId) {
        String sql = "select count(ocl.id) from tts.org_class_lesson ocl join tts.org_student_lesson osl on osl.lesson_id = ocl.id where osl.student_id = :studentId and ocl.course_id = :courseId and ocl.org_id = :orgId";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("courseId", courseId);
        paramMap.put("studentId", studentId);
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sql, (Map)paramMap, Integer.class);
    }

    @Override
    public int updateLessonClassRoom(Long orgId, Collection<Long> lessonIds, Long roomId) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return 0;
        }
        if (roomId == null) {
            roomId = 0L;
        }
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("roomId", roomId);
        params.put("lessonIds", lessonIds);
        String sql = "update tts.org_class_lesson set room_id=:roomId where orgId=:orgId and id in :lessonIds ";
        log.debug("update lesson sql:{} params:{}", (Object)sql, (Object)params);
        return this.getNamedJdbcTemplate().update(sql, (Map)params);
    }

    @Override
    public void batchUpdateLessonNumber(Map<String, ?>[] lessonIdNumberMaps) {
        if (ArrayUtils.isEmpty((Object[])lessonIdNumberMaps)) {
            return;
        }
        String sql = "update tts.org_class_lesson set number=:number where  id=:id ";
        log.debug("sql:{} batch update params:{}", (Object)sql, lessonIdNumberMaps);
        this.getNamedJdbcTemplate().batchUpdate(sql, (Map[])lessonIdNumberMaps);
    }

    @Override
    public Map<Long, Integer> getFinishLessonCount(Long orgId, Collection<Long> courseIds, final Integer delStatus) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        final Date now = new Date();
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(new String[]{"courseId"});
                builder.count("id", "num");
                builder.in("courseId", querySet);
                builder.group("courseId");
                if (delStatus != null) {
                    builder.eq("delStatus", (Serializable)delStatus);
                }
                builder.le("endTime", (Serializable)now);
                final HashMap result = Maps.newHashMap();
                OrgClassLessonDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Integer> getLessonCount(Long orgId, Collection<Long> courseIds, final Integer delStatus) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(new String[]{"courseId"});
                builder.count("id", "num");
                builder.in("courseId", querySet);
                builder.group("courseId");
                if (delStatus != null) {
                    builder.eq("delStatus", (Serializable)delStatus);
                }
                final HashMap result = Maps.newHashMap();
                OrgClassLessonDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<OrgClassLesson> getLessonByCourseId(Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        return this.queryList(builder, OrgClassLesson.class);
    }

    @Override
    public Map<Long, OrgClassLesson> getClassLessonMap(final Long orgId, Collection<Long> lessonIds, final Integer delStatus, final String ... props) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List list = (List)batchQueryTemplate.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgClassLesson>>(){

            public List<OrgClassLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(props);
                builder.in("id", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)delStatus);
                return OrgClassLessonDaoImpl.this.queryList(builder);
            }
        });
        HashMap map = Maps.newHashMap();
        for (OrgClassLesson po : list) {
            map.put(po.getId(), po);
        }
        return map;
    }

    @Override
    public Map<Long, OrgClassLesson> getClassLessonMap(Long orgId, Long courseId, Integer delStatus, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("orgId", (Serializable)orgId);
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        List list = this.queryList(builder);
        HashMap map = Maps.newHashMap();
        for (OrgClassLesson po : list) {
            map.put(po.getId(), po);
        }
        return map;
    }

    @Override
    public Integer getFinishLessonCount(Long orgId, Long courseId, Integer delStatus) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.eq("courseId", (Serializable)courseId);
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.le("endTime", (Serializable)new Date());
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer getLessonCount(Long orgId, Long courseId, Integer delStatus) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.eq("courseId", (Serializable)courseId);
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgClassLesson> querylessonsByEndTime(Date startTime, Date endTime, Integer delStatus, PageDto pageDto) {
        Preconditions.checkArgument((endTime != null ? 1 : 0) != 0, (Object)"endTime is null!");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.gt("courseId", (Serializable)Integer.valueOf(0));
        if (startTime != null) {
            builder.ge("endTime", (Serializable)startTime);
        }
        builder.lt("endTime", (Serializable)endTime);
        builder.desc("endTime");
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getCourseLessonCount(Long orgId, Collection<Long> courseIds, Long studentId, Long teacherId, Date endTime) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        final StringBuilder sb = new StringBuilder();
        final HashMap params = Maps.newHashMap();
        sb.append("select lesson.course_id AS courseId, count(lesson.id) AS num from tts.org_class_lesson lesson ");
        if (studentId != null) {
            sb.append("join tts.org_student_lesson student on lesson.id = student.lesson_id ");
            params.put("studentId", studentId);
        }
        if (teacherId != null) {
            sb.append("join tts.org_teacher_lesson teacher on lesson.id = teacher.lesson_id ");
            params.put("teacherId", teacherId);
        }
        sb.append("where lesson.del_status=0 and lesson.org_id=:orgId and lesson.course_id in (:courseIds) ");
        if (studentId != null) {
            sb.append("and student.student_id =:studentId ");
        }
        if (teacherId != null) {
            sb.append("and teacher.teacher_id =:teacherId ");
        }
        if (endTime != null) {
            sb.append("and lesson.end_time <=:endTime ");
            params.put("endTime", endTime);
        }
        params.put("orgId", orgId);
        sb.append("group by lesson.course_id ");
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                params.put("courseIds", querySet);
                final HashMap result = Maps.newHashMap();
                OrgClassLessonDaoImpl.this.getNamedJdbcTemplate().query(sb.toString(), params, new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<Long> filterLessonListByTime(Collection<Long> courseIds, Collection<Long> lessonIds, Date date) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.in("id", lessonIds);
        builder.in("courseId", courseIds);
        builder.le("endTime", (Serializable)date);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgClassLesson> getLeftRoomIdLessons(Long orgId, Long roomId, Date startTime, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("roomId", (Serializable)roomId);
        if (startTime != null) {
            builder.gt("startTime", (Serializable)startTime);
        }
        return this.queryList(builder);
    }

    @Override
    public List<Long> getOrgLessonIds(Long orgId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("startTime");
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Map<Long, Integer> getCourseAttendCountMap(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        String sql = "select ocl.course_id as courseId,count(osl.id) as cnt from tts.org_class_lesson ocl join tts.org_student_lesson osl on osl.lesson_id = ocl.id where ocl.org_id = :orgId and ocl.course_id in(:courseIds) and ocl.start_time < :now group by ocl.course_id order by field(courseId,:courseIds)";
        final HashMap resultMap = Maps.newHashMap();
        Date now = new Date();
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("courseIds", courseIds);
        paramMap.put("now", now);
        log.debug("sql = {},param = {}", (Object)sql, (Object)paramMap);
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                resultMap.put(rs.getLong("courseId"), rs.getInt("cnt"));
            }
        });
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getStudentAttendCountMap(Long orgId, Collection<Long> userIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        String sql = "select osl.student_id as userId, count(osl.id) as cnt from tts.org_class_lesson ocl join tts.org_student_lesson osl on osl.lesson_id = ocl.id where osl.student_id in(:userIds) and ocl.org_id = :orgId and ocl.start_time < :now group by osl.student_id order by field(userId,:userIds)";
        final HashMap resultMap = Maps.newHashMap();
        Date now = new Date();
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("userIds", userIds);
        paramMap.put("now", now);
        log.debug("sql = {},param = {}", (Object)sql, (Object)paramMap);
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                resultMap.put(rs.getLong("userId"), rs.getInt("cnt"));
            }
        });
        return resultMap;
    }

    @Override
    public List<Long> filterLessonList(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        if (CollectionUtils.isEmpty(teacherIds) && CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        HashMap params = Maps.newHashMap();
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct teacher.lesson_id from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append("where teacher.org_id =:orgId ");
        params.put("orgId", orgId);
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            sb.append("and teacher.teacher_id in (:teacherIds) ");
            params.put("teacherIds", teacherIds);
        }
        if (CollectionUtils.isNotEmpty(courseIds)) {
            sb.append("and lesson.course_id in (:courseIds)");
            params.put("courseIds", courseIds);
        }
        return this.getNamedJdbcTemplate().queryForList(sb.toString(), (Map)params, Long.class);
    }

    @Override
    public List<Long> queryFinishedLessonIds(Long orgId, Long teacherId, Date startTime, Date endTime) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null");
        Preconditions.checkArgument((startTime != null ? 1 : 0) != 0, (Object)"startTime is null");
        Preconditions.checkArgument((endTime != null ? 1 : 0) != 0, (Object)"endTime is null");
        final ArrayList result = Lists.newArrayList();
        HashMap params = Maps.newHashMap();
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("orgId", orgId);
        StringBuilder sb = new StringBuilder();
        if (teacherId != null) {
            params.put("teacherId", teacherId);
            sb.append("select distinct lesson.id from tts.org_class_lesson lesson, tts.org_lesson_sign sign, tts.org_teacher_lesson teacher ").append("where lesson.id = sign.lesson_id ").append("and lesson.id = teacher.lesson_id ").append("and lesson.org_id=:orgId ").append("and teacher.teacher_id =:teacherId ").append("and lesson.start_time >:startTime and lesson.start_time <:endTime and sign.status = 1");
        } else {
            sb.append("select distinct lesson.id from tts.org_class_lesson lesson, tts.org_lesson_sign sign ").append("where lesson.id = sign.lesson_id ").append("and lesson.org_id=:orgId ").append("and lesson.start_time >:startTime and lesson.start_time <:endTime and sign.status = 1");
        }
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                result.add(rs.getLong("id"));
            }
        });
        return result;
    }

    @Override
    public List<ClassHour> queryFinishedLessonCountByTeacherIds(Long orgId, Collection<Long> teacherIds, Date startTime, Date endTime) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null");
        Preconditions.checkArgument((startTime != null ? 1 : 0) != 0, (Object)"startTime is null");
        Preconditions.checkArgument((endTime != null ? 1 : 0) != 0, (Object)"endTime is null");
        if (teacherIds == null || teacherIds.size() == 0) {
            return Collections.emptyList();
        }
        HashMap params = Maps.newHashMap();
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("orgId", orgId);
        StringBuilder sb = new StringBuilder();
        params.put("teacherId", teacherIds);
        sb.append("select count(distinct lesson.id) as lessonCount ,teacher.teacher_id as teacherId from tts.org_class_lesson lesson, tts.org_lesson_sign sign, tts.org_teacher_lesson teacher ").append("where lesson.id = sign.lesson_id ").append("and lesson.id = teacher.lesson_id ").append("and lesson.org_id=:orgId ").append("and teacher.teacher_id in (:teacherId) ").append("and lesson.start_time >:startTime and lesson.start_time <:endTime and sign.status = 1 group by teacher.teacher_id");
        final ArrayList result = Lists.newArrayList();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                ClassHour classHour = new ClassHour();
                classHour.setTeacherId(rs.getLong("teacherId"));
                classHour.setLessonCount(rs.getInt("lessonCount"));
                result.add(classHour);
            }
        });
        return result;
    }

    @Override
    public List<ClassHour> queryTeacherClassHourList(Collection<Long> lessonIds, Long teacherId, final PageDto page, final boolean groupByCourse) {
        HashMap params = Maps.newHashMap();
        params.put("lessonId", lessonIds);
        if (teacherId != null) {
            params.put("teacherId", teacherId);
        }
        if (page != null) {
            StringBuilder countSb = new StringBuilder();
            if (groupByCourse) {
                countSb.append("select count(distinct lesson.course_id) num from tts.org_class_lesson lesson ").append("where lesson.id in (:lessonId) ");
            } else {
                countSb.append("select count(distinct teacher.teacher_id) num from tts.org_teacher_lesson teacher ").append("where teacher.lesson_id in (:lessonId) ");
            }
            this.getNamedJdbcTemplate().query(countSb.toString(), (Map)params, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    page.setCount(Integer.valueOf(rs.getInt("num")));
                }
            });
        }
        StringBuilder querySb = new StringBuilder();
        if (groupByCourse) {
            querySb.append("select teacher.teacher_id teacherId, l.course_id courseId, count(l.id) lessonCount, sum(TIMESTAMPDIFF(MINUTE,l.start_time,l.end_time)) minutes from tts.org_class_lesson l join tts.org_teacher_lesson teacher on l.id = teacher.lesson_id ");
            querySb.append("where teacher.lesson_id in (:lessonId) ");
            if (teacherId != null) {
                querySb.append("and teacher.teacher_id =:teacherId ");
            }
            querySb.append("group by teacher.teacher_id, l.course_id order by minutes desc ");
        } else {
            querySb.append("select teacher.teacher_id teacherId, count(l.id) lessonCount, sum(TIMESTAMPDIFF(MINUTE,l.start_time,l.end_time)) minutes from tts.org_class_lesson l join tts.org_teacher_lesson teacher on l.id = teacher.lesson_id ");
            querySb.append("where teacher.lesson_id in (:lessonId) ");
            if (teacherId != null) {
                querySb.append("and teacher.teacher_id=:teacherId ");
            }
            querySb.append("group by teacher.teacher_id order by minutes desc ");
        }
        if (page != null) {
            querySb.append("limit ").append((page.getPageNum() - 1) * page.getPageSize()).append(",").append(page.getPageNum() * page.getPageSize());
        }
        final ArrayList reuslt = Lists.newArrayList();
        this.getNamedJdbcTemplate().query(querySb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                ClassHour classHour = new ClassHour();
                classHour.setTeacherId(rs.getLong("teacherId"));
                if (groupByCourse) {
                    classHour.setCourseId(rs.getLong("courseId"));
                }
                classHour.setLessonCount(rs.getInt("lessonCount"));
                classHour.setMinutes(rs.getInt("minutes"));
                reuslt.add(classHour);
            }
        });
        if (page != null) {
            page.setCurPageCount(Integer.valueOf(reuslt.size()));
        }
        return reuslt;
    }

    @Override
    public Map<Long, List<OrgClassLesson>> getLessonMapByCourseAndLessonIds(final Long orgId, final Collection<Long> courseIds, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds) || CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List list = (List)batchQueryTemplate.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgClassLesson>>(){

            public List<OrgClassLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("id", querySet);
                builder.in("courseId", courseIds);
                builder.eq("orgId", (Serializable)orgId);
                return OrgClassLessonDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)list, (Function)new Function<OrgClassLesson, Long>(){

            public Long apply(OrgClassLesson arg0) {
                return arg0.getCourseId();
            }
        });
    }

    @Override
    public ClassHour queryTeacherClassHour(Collection<Long> lessonIds, Long teacherId) {
        HashMap params = Maps.newHashMap();
        params.put("lessonId", lessonIds);
        if (teacherId != null) {
            params.put("teacherId", teacherId);
        }
        StringBuilder querySb = new StringBuilder();
        querySb.append("select teacher.teacher_id teacherId, count(l.id) lessonCount, sum(TIMESTAMPDIFF(MINUTE,l.start_time,l.end_time)) minutes from tts.org_class_lesson l join tts.org_teacher_lesson teacher on l.id = teacher.lesson_id ");
        querySb.append("where teacher.lesson_id in (:lessonId) ");
        if (teacherId != null) {
            querySb.append("and teacher.teacher_id=:teacherId ");
        }
        querySb.append("group by teacher.teacher_id order by minutes desc ");
        final ClassHour classHour = new ClassHour();
        this.getNamedJdbcTemplate().query(querySb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                classHour.setTeacherId(rs.getLong("teacherId"));
                classHour.setLessonCount(rs.getInt("lessonCount"));
                classHour.setMinutes(rs.getInt("minutes"));
            }
        });
        return classHour;
    }

    @Override
    public Map<Long, Integer> getLessonTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from tts.org_class_lesson where org_id in (:orgIds)";
        if (startTime != null && endTime != null) {
            sql = sql + " and create_time between :startTime and :endTime ";
            param.put("endTime", endTime);
            param.put("startTime", startTime);
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgNamber = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgNamber, count);
                }
                return map;
            }
        });
    }

    @Override
    public void refreshOrgClassLesson(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update tts.org_class_lesson set del_status =1 where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public Map<Long, Integer> getArrangedClassCount(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(distinct number) count from tts.org_class_lesson where org_id in (:orgIds)";
        if (startTime != null && endTime != null) {
            sql = sql + " and create_time between :startTime and :endTime ";
            param.put("endTime", endTime);
            param.put("startTime", startTime);
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgNamber = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgNamber, count);
                }
                return map;
            }
        });
    }
}

