/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.dto.CoursePurchaseDto;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class CoursePurchaseDaoImpl
extends JdbcTemplateDaoSupport<CoursePurchase>
implements CoursePurchaseDao {
    public CoursePurchaseDaoImpl() {
        super(CoursePurchase.class);
    }

    @Override
    public List<CoursePurchase> queryByLastUpdateTime(Long orgId, Integer status, Date lastUpdateTime, int maxSize, String ... propes) {
        SingleSqlBuilder builder = this.createSqlBuilder(propes);
        if (orgId != null && orgId > 0L) {
            builder.eq("orgId", (Serializable)orgId);
        } else {
            builder.gt("orgId", (Serializable)Integer.valueOf(0));
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.gt("updateTime", (Serializable)lastUpdateTime);
        if (maxSize > 0) {
            builder.setMaxSize(Integer.valueOf(maxSize));
        }
        builder.asc("updateTime");
        return this.queryList(builder);
    }

    @Override
    public Map<Long, String> queryStudentName(Collection<Long> userIds) {
        MapBatchQueryTemplate queryTemplate = new MapBatchQueryTemplate();
        return (Map)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, String>>(){

            public Map<Long, String> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = CoursePurchaseDaoImpl.this.createSqlBuilder(new String[]{"userId", "userName"});
                builder.in("userId", querySet);
                List results = CoursePurchaseDaoImpl.this.queryList(builder);
                return CollectorUtil.collectMap((Collection)results, (String)"getUserId", (String)"getUserName");
            }
        });
    }

    @Override
    public List<Long> getLatestdPurchaseCourseIdsList(Long orgId) {
        String querySql = "select distinct course_id from pay.course_purchase where organization_id = :orgId and course_type = 4 order by update_time desc";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        List list = this.getNamedJdbcTemplate().queryForList(querySql, (Map)paramMap, Long.class);
        return list;
    }

    @Override
    public List<CoursePurchase> getCoursePurchaseList(Long orgId, Long userId, Long parentPurchaseId, Integer courseType, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("parentPurchaseId", (Serializable)parentPurchaseId);
        builder.eq("courseType", (Serializable)courseType);
        builder.eq("status", (Serializable)status);
        return this.queryList(builder);
    }

    @Override
    public List<CoursePurchase> getCousePurchaseListByMinId(Long minId, Date lastDate, int maxSize, Integer courseType, Integer parentPurchaseType, Integer status, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("updateTime", (Serializable)lastDate);
        } else {
            builder.gt("id", (Serializable)minId);
        }
        if (parentPurchaseType != null) {
            builder.ne("parent_purchase_type", (Serializable)parentPurchaseType);
        }
        builder.eq("parentPurchaseId", (Serializable)Integer.valueOf(0));
        builder.eq("courseType", (Serializable)courseType);
        builder.eq("status", (Serializable)status);
        builder.asc("createTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public List<CoursePurchase> getCoursePurchaseList(Long orgId, Long userId, Integer status, String ... queryPrps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryPrps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("status", (Serializable)status);
        return this.queryList(builder);
    }

    @Override
    public List<CoursePurchase> getCoursePurchaseList(Long orgId, Integer status, String ... queryPrps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryPrps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)status);
        return this.queryList(builder);
    }

    @Override
    public List<CoursePurchase> getCoursePurchaseList(Date updateTime, Integer status, List<Integer> courseTypes, PageDto page, String ... queryPrps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryPrps);
        builder.gt("updateTime", (Serializable)updateTime);
        builder.in("courseType", courseTypes);
        builder.eq("status", (Serializable)status);
        builder.gt("orgId", (Serializable)Integer.valueOf(0));
        builder.eq("parentPurchaseId", (Serializable)Integer.valueOf(0));
        builder.desc("updateTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public int getTotalOrgPurchase(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(1));
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getOrgPuchaseByTime(Long orgId, Date startDate, Date endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(1));
        builder.ge("createTime", (Serializable)startDate);
        builder.le("createTime", (Serializable)endDate);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public int getCourseTotalCount(Long orgId, Long courseNum) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(1));
        builder.eq("courseNumber", (Serializable)courseNum);
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getCourseTotalCount(Long courseNum) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("status", (Serializable)Integer.valueOf(1));
        builder.eq("courseNumber", (Serializable)courseNum);
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getCourseCountByTime(Long orgId, Long courseNum, Date startDate, Date endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(1));
        builder.eq("courseNumber", (Serializable)courseNum);
        builder.ge("createTime", (Serializable)startDate);
        builder.le("createTime", (Serializable)endDate);
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getCourseCountByTime(Long orgId, Date startDate, Date endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(1));
        builder.ge("createTime", (Serializable)startDate);
        builder.le("createTime", (Serializable)endDate);
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public List<CoursePurchase> getUnSuccessList4CourseIdUserIdOrgId(int start, int maxSize) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.gt("orgId", (Serializable)Integer.valueOf(0));
        builder.ne("status", (Serializable)Integer.valueOf(1));
        builder.asc("id");
        builder.setMaxSize(Integer.valueOf(maxSize));
        builder.setStart(start);
        builder.groupByNames(new String[]{"orgId", "courseId", "userId"});
        return this.queryList(builder);
    }

    @Override
    public List<CoursePurchase> getSuccessList(Collection<List<Object>> groupValues) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"orgId", "courseId", "userId"});
        builder.tupleIn(Lists.newArrayList((Object[])new String[]{"orgId", "courseId", "userId"}), groupValues);
        builder.eq("status", (Serializable)Integer.valueOf(1));
        return this.queryList(builder);
    }

    @Override
    public Map<Long, CoursePurchaseDto> getIncomeTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select organization_id as org_id, count(id) count, sum(except_coupon_money) pay_money_sum from pay.course_purchase where status = 1 and organization_id in (:orgIds) and except_coupon_money != 0 ";
        if (startTime != null && endTime != null) {
            sql = sql + " AND create_time between :startTime and :endTime ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql = sql + " group by organization_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, CoursePurchaseDto>>(){

            public Map<Long, CoursePurchaseDto> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, CoursePurchaseDto> map = new HashMap<Long, CoursePurchaseDto>();
                while (rs.next()) {
                    CoursePurchaseDto coursePurchaseDto = new CoursePurchaseDto();
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    Double payMoneySum = rs.getDouble("pay_money_sum");
                    coursePurchaseDto.setCount(count);
                    coursePurchaseDto.setPayMoneySum(payMoneySum);
                    map.put(orgId, coursePurchaseDto);
                }
                return map;
            }
        });
    }

    @Override
    public List<CoursePurchase> getByOrgIds(Date startTime, Date endTime, List<Long> orgIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseType", (Serializable)Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        builder.eq("status", (Serializable)Integer.valueOf(PayStatus.SUCESS.getCode()));
        builder.in("orgId", orgIds);
        builder.ge("createTime", (Serializable)startTime);
        builder.le("createTime", (Serializable)endTime);
        builder.desc("createTime");
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public Integer getCountByOrgIds(Date startTime, Date endTime, List<Long> orgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("courseType", (Serializable)Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        builder.eq("status", (Serializable)Integer.valueOf(PayStatus.SUCESS.getCode()));
        builder.in("orgId", orgIds);
        builder.ge("createTime", (Serializable)startTime);
        builder.le("createTime", (Serializable)endTime);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public CoursePurchase getByPurcahseId(Long purchaseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("purchaseId", (Serializable)purchaseId);
        builder.setMaxSize(Integer.valueOf(1));
        return (CoursePurchase)this.uniqueResult(builder);
    }

    @Override
    public CoursePurchase getByPurcahseIdCourse(Long parentPurchaseId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.or(Expressions.eq((String)"parentPurchaseId", (Serializable)parentPurchaseId), Expressions.eq((String)"purchaseId", (Serializable)parentPurchaseId));
        builder.eq("courseId", (Serializable)courseId);
        builder.setMaxSize(Integer.valueOf(1));
        return (CoursePurchase)this.uniqueResult(builder);
    }
}

