package com.baijia.tianxiao.dal.activity.mongo;

import com.baijia.commons.lang.utils.PropertiesReader;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;

import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

import java.util.ArrayList;
import java.util.Properties;

/**
 * Created by liuxp on 16/4/6.
 */
public class MongoTemplate {

    private static MongoClient mongoClient;
    private static MongoDatabase database;
    static {

        Properties prop = PropertiesReader.fillProperties("mongodb.properties");
        String db = prop.getProperty("mongo.db");
        String mongoUrl = prop.getProperty("mongo.host");
        try {
            MongoClientURI url = new MongoClientURI(mongoUrl);
            mongoClient = new MongoClient(url);
        } catch (Exception e) {
            String user = prop.getProperty("mongo.username");
            String password = prop.getProperty("mongo.password");
            Integer port = Integer.parseInt(prop.getProperty("mongo.port"));
            ArrayList<MongoCredential> credentials = new ArrayList<>();
            if (StringUtils.isNotBlank(user) && StringUtils.isNotBlank(password)) {
                MongoCredential mongoCredential = MongoCredential.createCredential(user, db, password.toCharArray());
                credentials.add(mongoCredential);
            }
            mongoClient = new MongoClient(new ServerAddress(mongoUrl, port), credentials);
        }
        database = mongoClient.getDatabase(db);

    }

    public static MongoCollection<Document> getConnection(String collection) {
        return database.getCollection(collection);
    }

}
