/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.mongo;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

public class MongoTemplate {
    private static MongoClient mongoClient;
    private static MongoDatabase database;

    public static MongoCollection<Document> getConnection(String collection) {
        return database.getCollection(collection);
    }

    static {
        Properties prop = PropertiesReader.fillProperties((String)"mongodb.properties");
        String db = prop.getProperty("mongo.db");
        String mongoUrl = prop.getProperty("mongo.host");
        try {
            MongoClientURI url = new MongoClientURI(mongoUrl);
            mongoClient = new MongoClient(url);
        }
        catch (Exception e) {
            String user = prop.getProperty("mongo.username");
            String password = prop.getProperty("mongo.password");
            Integer port = Integer.parseInt(prop.getProperty("mongo.port"));
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
            if (StringUtils.isNotBlank((CharSequence)user) && StringUtils.isNotBlank((CharSequence)password)) {
                MongoCredential mongoCredential = MongoCredential.createCredential((String)user, (String)db, (char[])password.toCharArray());
                credentials.add(mongoCredential);
            }
            mongoClient = new MongoClient(new ServerAddress(mongoUrl, port.intValue()), credentials);
        }
        database = mongoClient.getDatabase(db);
    }
}

