package com.baijia.tianxiao.dal.activity.mongo;

import java.util.ArrayList;
import java.util.Properties;

import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

import com.baijia.tianxiao.util.GenericsUtils;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/4/6.
 */
@Slf4j
public class MongoTemplate {

    private static MongoClient mongoClient;
    private static MongoDatabase database;
    private static volatile boolean isInitOver = false;

    public static final String mongoPropertiesName = "mongodb.properties";
    static {
        Properties prop = GenericsUtils.findPropWithNoError(mongoPropertiesName);
        if (prop == null) {
            log.info("can not init mongoTemplate cause by can not find any properties file with name :{} ",
                mongoPropertiesName);
        } else {
            String db = prop.getProperty("mongo.db");
            String mongoUrl = prop.getProperty("mongo.host");
            if (GenericsUtils.notNullAndEmpty(mongoUrl)) {
                boolean isWithUrl = mongoUrl.startsWith("mongodb:");
                try {
                    if (!isWithUrl) {
                        String user = prop.getProperty("mongo.username");
                        String password = prop.getProperty("mongo.password");
                        Integer port = Integer.parseInt(prop.getProperty("mongo.port"));
                        ArrayList<MongoCredential> credentials = new ArrayList<>();
                        if (StringUtils.isNotBlank(user) && StringUtils.isNotBlank(password)) {
                            MongoCredential mongoCredential =
                                MongoCredential.createCredential(user, db, password.toCharArray());
                            credentials.add(mongoCredential);
                        }
                        mongoClient = new MongoClient(new ServerAddress(mongoUrl, port), credentials);
                    } else {
                        MongoClientURI url = new MongoClientURI(mongoUrl);
                        mongoClient = new MongoClient(url);
                    }
                    database = mongoClient.getDatabase(db);
                    log.info("database is:{} ", database);
                    isInitOver = true;
                } catch (Exception e) {
                    log.warn("can not conntect to mongdb server:{} ", prop);
                }
            } else {
                log.info("can not find mongoUrl with Propertis:key:{} and value:{}", prop.keys(), prop.values());
            }
        }

    }

    public static MongoCollection<Document> getConnection(String collection) {
        return database.getCollection(collection);
    }

    public static MongoClient getMongoClient() {
        return mongoClient;
    }

    public static MongoDatabase getMongoDatabase() {
        return database;
    }

    public static boolean isInitOver() {
        return isInitOver;
    }

}
