
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.activity.mongo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.mongodb.client.result.DeleteResult;
import org.bson.Document;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.util.JSON;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Mar 8, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
@Service
public class MongoDBOperator {

    private List<String> tables = Lists.newArrayList();
    private MongoDatabase database = null;
    private volatile boolean isInitSucc = true;

    public MongoDBOperator() {
        try {
            if (MongoTemplate.isInitOver()) {
                this.database = MongoTemplate.getMongoDatabase();
                MongoIterable<String> collections = this.database.listCollectionNames();
                MongoCursor<String> cursor = collections.iterator();
                while (cursor.hasNext()) {
                    this.tables.add(cursor.next());
                }
            } else {
                isInitSucc = false;
                log.info(" can not init MongoDBOperator ");
            }
        } catch (Exception e) {
            isInitSucc = false;
            log.info(" can not init MongoDBOperator ");
            log.warn("exception is:{} ", e);
        }
    }

    private void checkIndex(String[] uniqueKeys) {
        // 如果发现没有索引
    }

    private void initTable(String tableName, String[] uniqueKeys) {
        synchronized (this.tables) {
            if (!this.tables.contains(tableName)) {
                this.database.createCollection(tableName);
                MongoCollection<Document> collection = this.database.getCollection(tableName);
                if (GenericsUtils.notNullAndEmpty(uniqueKeys)) {
                    for (String str : uniqueKeys) {
                        log.info("create unique index : {} ", str);
                        Document key = new Document(str, 1);
                        IndexOptions indexOption = new IndexOptions();
                        indexOption.unique(true);
                        collection.createIndex(key, indexOption);
                    }
                }
                this.tables.add(tableName);
            }
        }
    }

    public MongoCollection<Document> getTableCollection(String tableName, String...uniqueKeys) {
        if (!isInitSucc && this.database != null) {
            throw new RuntimeException("mongodbserver is not init ");
        }
        if (!this.tables.contains(tableName)) {
            log.info("table {} not exists!", tableName);
            initTable(tableName, uniqueKeys);
        }
        this.checkIndex(uniqueKeys);
        return this.database.getCollection(tableName);
    }

    public void insertDocument(String tableName, Object obj, String...uniqueKeys) {
        this.insertDocuments(tableName, Arrays.asList(obj), uniqueKeys);
    }

    @SuppressWarnings("unchecked")
    public void insertDocuments(String tableName, Collection<? extends Object> objs, String...uniqueKeys) {
        if (GenericsUtils.isNullOrEmpty(objs)) {
            return;
        }
        MongoCollection<Document> tableCollection = this.getTableCollection(tableName, uniqueKeys);
        List<Document> documents = new ArrayList<>();
        Gson gson = new Gson();
        for (Object obj : objs) {
            if (obj instanceof Document) {
                documents.add((Document) obj);
            } else {
                DBObject parse = (DBObject) JSON.parse(gson.toJson(obj));
                documents.add(new Document(parse.toMap()));
            }
        }
        try {
            tableCollection.insertMany(documents);
        } catch (MongoBulkWriteException e) {
            log.error("dub document ");
        } catch (Exception e) {
            log.error("error exception : {} ", e);
        }
    }

    public <T> T searchObj(String tableName, Map<String, ? extends Object> searcher, Class<T> clazz, Gson...gsons) {
        List<T> searchObjs = this.searchObjs(tableName, searcher, clazz, gsons);
        if (GenericsUtils.notNullAndEmpty(searchObjs)) {
            return searchObjs.get(0);
        }
        return null;
    }

    public <T> List<T> searchObjs(String tableName, Map<String, ? extends Object> searcher, Class<T> clazz,
        Gson...gsons) {
        if (searcher == null) {
            searcher = new HashMap<>();
        }
        MongoCollection<Document> tableCollection = this.getTableCollection(tableName);
        Document doc = new Document();
        for (Map.Entry<String, ? extends Object> entry : searcher.entrySet()) {
            doc.append(entry.getKey(), entry.getValue());
        }
        log.info("======= doc is :{} ", doc.toJson());
        FindIterable<Document> find = tableCollection.find(doc);
        MongoCursor<Document> iterator = find.iterator();
        List<T> ret = new ArrayList<>();
        Gson gson = null;
        if (GenericsUtils.isNullOrEmpty(gsons)) {
            gson = new Gson();
        } else {
            gson = gsons[0];
        }
        while (iterator.hasNext()) {
            Document next = iterator.next();
            ret.add(gson.fromJson(next.toJson(), clazz));
        }
        return ret;
    }

    /**
     * @param obj
     * @param updateQuery
     */
    @SuppressWarnings("unchecked")
    public void updateDocument(Object obj, String tableName, Map<String, Object> updateQuery) {
        if (GenericsUtils.isNullOrEmpty(updateQuery)) {
            return;
        }
        MongoCollection<Document> tableCollection = this.getTableCollection(tableName);
        Document updateFilter = new Document();
        for (Map.Entry<String, ? extends Object> entry : updateQuery.entrySet()) {
            updateFilter.append(entry.getKey(), entry.getValue());
        }
        Gson gson = new Gson();
        Document document = new Document();
        if (obj instanceof Document) {
            document = (Document) obj;
        } else {
            DBObject parse = (DBObject) JSON.parse(gson.toJson(obj));
            document = new Document(parse.toMap());
        }
        tableCollection.findOneAndReplace(updateFilter, document);
    }

    public void delDocument(String tableName, Map<String, Object> updateQuery){
        MongoCollection<Document> tableCollection = this.getTableCollection(tableName);
        Document updateFilter = new Document();
        for (Map.Entry<String, ? extends Object> entry : updateQuery.entrySet()) {
            updateFilter.append(entry.getKey(), entry.getValue());
        }
        DeleteResult result = tableCollection.deleteMany(updateFilter);
        log.info("del document param:{} with updateFilter:{}, result:{} ", updateQuery, updateFilter, result);
    }

    /**
     * @param collection
     * @param map
     * @param pageDto
     * @param orderByObject
     * @param class1
     * @return
     */
    public <T> List<T> searchObjs(String tableName, Map<String, ? extends Object> searcher, PageDto pageDto,
        BasicDBObject orderByObject, Class<T> clazz) {
        if (searcher == null) {
            searcher = new HashMap<>();
        }
        MongoCollection<Document> tableCollection = this.getTableCollection(tableName);
        Document doc = new Document();
        for (Map.Entry<String, ? extends Object> entry : searcher.entrySet()) {
            doc.append(entry.getKey(), entry.getValue());
        }
        FindIterable<Document> find = tableCollection.find(doc);
        long count = tableCollection.count(doc);
        if (pageDto != null) {
            find.skip((pageDto.getPageNum() - 1) * pageDto.getPageSize());
            find.limit(pageDto.getPageSize());
            pageDto.setCount((int) count);
        }
        if (orderByObject != null) {
            find.sort(orderByObject);
        }
        MongoCursor<Document> iterator = find.iterator();
        List<T> ret = new ArrayList<>();
        Gson gson = null;
        gson = new Gson();
        while (iterator.hasNext()) {
            Document next = iterator.next();
            ret.add(gson.fromJson(next.toJson(), clazz));
        }
        return ret;
    }

}
