/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.mongo;

import com.baijia.tianxiao.util.GenericsUtils;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoTemplate {
    private static final Logger log = LoggerFactory.getLogger(MongoTemplate.class);
    private static MongoClient mongoClient;
    private static MongoDatabase database;
    private static volatile boolean isInitOver;
    public static final String mongoPropertiesName = "mongodb.properties";

    public static MongoCollection<Document> getConnection(String collection) {
        return database.getCollection(collection);
    }

    public static MongoClient getMongoClient() {
        return mongoClient;
    }

    public static MongoDatabase getMongoDatabase() {
        return database;
    }

    public static boolean isInitOver() {
        return isInitOver;
    }

    static {
        isInitOver = false;
        Properties prop = GenericsUtils.findPropWithNoError((String)mongoPropertiesName);
        if (prop == null) {
            log.info("can not init mongoTemplate cause by can not find any properties file with name :{} ", (Object)mongoPropertiesName);
        } else {
            String db = prop.getProperty("mongo.db");
            String mongoUrl = prop.getProperty("mongo.host");
            if (GenericsUtils.notNullAndEmpty((Object)mongoUrl)) {
                boolean isWithUrl = mongoUrl.startsWith("mongodb:");
                try {
                    if (!isWithUrl) {
                        String user = prop.getProperty("mongo.username");
                        String password = prop.getProperty("mongo.password");
                        Integer port = Integer.parseInt(prop.getProperty("mongo.port"));
                        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
                        if (StringUtils.isNotBlank((CharSequence)user) && StringUtils.isNotBlank((CharSequence)password)) {
                            MongoCredential mongoCredential = MongoCredential.createCredential((String)user, (String)db, (char[])password.toCharArray());
                            credentials.add(mongoCredential);
                        }
                        mongoClient = new MongoClient(new ServerAddress(mongoUrl, port.intValue()), credentials);
                    } else {
                        MongoClientURI url = new MongoClientURI(mongoUrl);
                        mongoClient = new MongoClient(url);
                    }
                    database = mongoClient.getDatabase(db);
                    log.info("database is:{} ", (Object)database);
                    isInitOver = true;
                }
                catch (Exception e) {
                    log.warn("can not conntect to mongdb server:{} ", (Object)prop);
                }
            } else {
                log.info("can not find mongoUrl with Propertis:key:{} and value:{}", prop.keys(), prop.values());
            }
        }
    }
}

