/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.mongo;

import com.baijia.tianxiao.dal.activity.mongo.MongoTemplate;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MongoDBOperator {
    private static final Logger log = LoggerFactory.getLogger(MongoDBOperator.class);
    private List<String> tables = Lists.newArrayList();
    private MongoDatabase database = null;
    private volatile boolean isInitSucc = true;

    public MongoDBOperator() {
        try {
            if (MongoTemplate.isInitOver()) {
                this.database = MongoTemplate.getMongoDatabase();
                MongoIterable collections = this.database.listCollectionNames();
                MongoCursor cursor = collections.iterator();
                while (cursor.hasNext()) {
                    this.tables.add((String)cursor.next());
                }
            } else {
                this.isInitSucc = false;
                log.info(" can not init MongoDBOperator ");
            }
        }
        catch (Exception e) {
            this.isInitSucc = false;
            log.info(" can not init MongoDBOperator ");
            log.warn("exception is:{} ", (Throwable)e);
        }
    }

    private void checkIndex(String[] uniqueKeys) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTable(String tableName, String[] uniqueKeys) {
        List<String> list = this.tables;
        synchronized (list) {
            if (!this.tables.contains(tableName)) {
                this.database.createCollection(tableName);
                MongoCollection collection = this.database.getCollection(tableName);
                if (GenericsUtils.notNullAndEmpty((Object)uniqueKeys)) {
                    for (String str : uniqueKeys) {
                        log.info("create unique index : {} ", (Object)str);
                        Document key = new Document(str, (Object)1);
                        IndexOptions indexOption = new IndexOptions();
                        indexOption.unique(true);
                        collection.createIndex((Bson)key, indexOption);
                    }
                }
                this.tables.add(tableName);
            }
        }
    }

    public MongoCollection<Document> getTableCollection(String tableName, String ... uniqueKeys) {
        if (!this.isInitSucc && this.database != null) {
            throw new RuntimeException("mongodbserver is not init ");
        }
        if (!this.tables.contains(tableName)) {
            log.info("table {} not exists!", (Object)tableName);
            this.initTable(tableName, uniqueKeys);
        }
        this.checkIndex(uniqueKeys);
        return this.database.getCollection(tableName);
    }

    public void insertDocument(String tableName, Object obj, String ... uniqueKeys) {
        this.insertDocuments(tableName, Arrays.asList(obj), uniqueKeys);
    }

    public void insertDocuments(String tableName, Collection<? extends Object> objs, String ... uniqueKeys) {
        if (GenericsUtils.isNullOrEmpty(objs)) {
            return;
        }
        MongoCollection<Document> tableCollection = this.getTableCollection(tableName, uniqueKeys);
        ArrayList<Document> documents = new ArrayList<Document>();
        Gson gson = new Gson();
        for (Object object : objs) {
            if (object instanceof Document) {
                documents.add((Document)object);
                continue;
            }
            DBObject parse = (DBObject)JSON.parse((String)gson.toJson(object));
            documents.add(new Document(parse.toMap()));
        }
        try {
            tableCollection.insertMany(documents);
        }
        catch (MongoBulkWriteException e) {
            log.error("dub document ");
        }
        catch (Exception e) {
            log.error("error exception : {} ", (Throwable)e);
        }
    }

    public <T> T searchObj(String tableName, Map<String, ? extends Object> searcher, Class<T> clazz, Gson ... gsons) {
        List<T> searchObjs = this.searchObjs(tableName, searcher, clazz, gsons);
        if (GenericsUtils.notNullAndEmpty(searchObjs)) {
            return searchObjs.get(0);
        }
        return null;
    }

    public <T> List<T> searchObjs(String tableName, Map<String, ? extends Object> searcher, Class<T> clazz, Gson ... gsons) {
        if (searcher == null) {
            searcher = new HashMap<String, Object>();
        }
        MongoCollection<Document> tableCollection = this.getTableCollection(tableName, new String[0]);
        Document doc = new Document();
        for (Map.Entry<String, ? extends Object> entry : searcher.entrySet()) {
            doc.append(entry.getKey(), entry.getValue());
        }
        log.info("======= doc is :{} ", (Object)doc.toJson());
        FindIterable find = tableCollection.find((Bson)doc);
        MongoCursor iterator = find.iterator();
        ArrayList<Object> ret = new ArrayList<Object>();
        Gson gson = null;
        gson = GenericsUtils.isNullOrEmpty((Object)gsons) ? new Gson() : gsons[0];
        while (iterator.hasNext()) {
            Document next = (Document)iterator.next();
            ret.add(gson.fromJson(next.toJson(), clazz));
        }
        return ret;
    }

    public void updateDocument(Object obj, String tableName, Map<String, Object> updateQuery) {
        if (GenericsUtils.isNullOrEmpty(updateQuery)) {
            return;
        }
        MongoCollection<Document> tableCollection = this.getTableCollection(tableName, new String[0]);
        Document updateFilter = new Document();
        for (Map.Entry<String, Object> entry : updateQuery.entrySet()) {
            updateFilter.append(entry.getKey(), entry.getValue());
        }
        Gson gson = new Gson();
        Document document = new Document();
        if (obj instanceof Document) {
            document = (Document)obj;
        } else {
            DBObject parse = (DBObject)JSON.parse((String)gson.toJson(obj));
            document = new Document(parse.toMap());
        }
        tableCollection.findOneAndReplace((Bson)updateFilter, (Object)document);
    }

    public <T> List<T> searchObjs(String tableName, Map<String, ? extends Object> searcher, PageDto pageDto, BasicDBObject orderByObject, Class<T> clazz) {
        if (searcher == null) {
            searcher = new HashMap<String, Object>();
        }
        MongoCollection<Document> tableCollection = this.getTableCollection(tableName, new String[0]);
        Document doc = new Document();
        for (Map.Entry<String, ? extends Object> entry : searcher.entrySet()) {
            doc.append(entry.getKey(), entry.getValue());
        }
        FindIterable find = tableCollection.find((Bson)doc);
        long count = tableCollection.count((Bson)doc);
        if (pageDto != null) {
            find.skip((pageDto.getPageNum() - 1) * pageDto.getPageSize());
            find.limit(pageDto.getPageSize().intValue());
            pageDto.setCount(Integer.valueOf((int)count));
        }
        if (orderByObject != null) {
            find.sort((Bson)orderByObject);
        }
        MongoCursor iterator = find.iterator();
        ArrayList<Object> ret = new ArrayList<Object>();
        Gson gson = null;
        gson = new Gson();
        while (iterator.hasNext()) {
            Document next = (Document)iterator.next();
            ret.add(gson.fromJson(next.toJson(), clazz));
        }
        return ret;
    }
}

