/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.article.impl;

import com.baijia.tianxiao.dal.activity.dao.article.OrgTeacherDocumentMongoDbDao;
import com.baijia.tianxiao.dal.activity.mongo.MongoDBOperator;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTeacherDocumentMongoDbDaoImpl
implements OrgTeacherDocumentMongoDbDao {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherDocumentMongoDbDaoImpl.class);
    @Autowired(required=false)
    private MongoDBOperator mongoDBOperator;

    @Override
    public List<Map<String, Object>> listByQuery(Integer orgId, Integer useStatus, Integer countType, Integer orderType, String searchKey, PageDto pageDto) {
        if (pageDto == null) {
            pageDto = new PageDto();
            pageDto.setPageNum(Integer.valueOf(1));
            pageDto.setPageSize(Integer.valueOf(100));
        }
        log.info("solr with params -- orgID:{}", (Object)orgId);
        String currentDate = DateUtil.getCurrentYM();
        BasicDBObject createRegex = this.createRegex("id", "t_*");
        BasicDBObject createEqulas = this.createEqulas("orgId", orgId);
        BasicDBObject createEqulas2 = this.createEqulas("dataMonth", currentDate);
        BasicDBObject createEqulas3 = null;
        if (useStatus != null) {
            createEqulas3 = this.createEqulas("useStatus", useStatus);
        } else {
            List<Integer> useStatuses = Arrays.asList(0, 1);
            createEqulas3 = this.createIn("useStatus", useStatuses);
        }
        BasicDBObject createManyRegex = null;
        if (GenericsUtils.notNullAndEmpty((Object)searchKey)) {
            createManyRegex = this.createManyRegex(".*" + searchKey + ".*", "name", "mobile");
        }
        TwoTuple<String, Integer> sortRule = this.getSolrRule(countType, orderType);
        BasicDBObject orderByObject = new BasicDBObject((String)sortRule.first, (Object)((Integer)sortRule.second == 0 ? 1 : -1));
        ArrayList queryConditions = Lists.newArrayList();
        queryConditions.add(createRegex);
        queryConditions.add(createEqulas);
        queryConditions.add(createEqulas2);
        queryConditions.add(createEqulas3);
        if (createManyRegex != null) {
            queryConditions.add(createManyRegex);
        }
        BasicDBObject createAndDBObject = this.createAndDBObject(queryConditions);
        log.info("query with createAndDBObject is:{} and pageDto :{} and orderByObject :{} ", new Object[]{createAndDBObject.toMap(), pageDto, orderByObject});
        List<Map<String, Object>> retListOfMap = this.mongoDBOperator.searchObjs("orgTeacherDocuments", (Map<String, ? extends Object>)createAndDBObject.toMap(), pageDto, orderByObject, Map.class);
        log.info("search retListOfMap is :{} ", retListOfMap);
        return retListOfMap;
    }

    private BasicDBObject createAndDBObject(List<BasicDBObject> queryConditions) {
        return this.createAndDBObject(queryConditions.toArray(new BasicDBObject[queryConditions.size()]));
    }

    public TwoTuple<String, Integer> getSolrRule(Integer countType, Integer orderType) {
        String field = "createTime";
        Integer order = 0;
        switch (countType) {
            case 0: {
                field = "createTime";
                break;
            }
            case 1: {
                field = "finishedClassTime";
                break;
            }
            case 2: {
                field = "hasSignupStudentCount";
                break;
            }
            case 3: {
                field = "scoreNum";
                break;
            }
            case 4: {
                field = "pauseTime";
                break;
            }
            default: {
                field = "createTime";
            }
        }
        if (orderType != null && orderType == 2) {
            order = 1;
        }
        return TupleUtil.tuple((Object)field, (Object)order);
    }

    private BasicDBObject createManyRegex(String regexStr, String ... fields) {
        ArrayList retBasicDBObject = Lists.newArrayList();
        for (String field : fields) {
            BasicDBObject createRegex = this.createRegex(field, regexStr);
            retBasicDBObject.add(createRegex);
        }
        return this.createOrDBObject(retBasicDBObject.toArray(new BasicDBObject[retBasicDBObject.size()]));
    }

    public BasicDBObject createAndDBObject(BasicDBObject ... andBasicDBObject) {
        if (GenericsUtils.isNullOrEmpty((Object)andBasicDBObject)) {
            return new BasicDBObject();
        }
        List<BasicDBObject> asList = Arrays.asList(andBasicDBObject);
        return new BasicDBObject("$and", asList);
    }

    public BasicDBObject createEqulas(String key, Object value) {
        return new BasicDBObject(key, value);
    }

    public BasicDBObject createIn(String fieldName, Collection<? extends Object> values) {
        BasicDBList valueOfList = new BasicDBList();
        for (Object object : values) {
            valueOfList.add(object);
        }
        BasicDBObject in = new BasicDBObject("$in", (Object)valueOfList);
        return new BasicDBObject(fieldName, (Object)in);
    }

    public static void main(String[] args) {
        Pattern pattern = Pattern.compile(".*\u54c8\u54c8.*");
        Matcher matcher = pattern.matcher("fdsf\u54c8\u54c8fdsf");
        System.out.println(matcher.find());
    }

    public BasicDBObject createRegex(String fieldName, String regexStr) {
        Pattern pattern = Pattern.compile(regexStr);
        BasicDBObject query = new BasicDBObject(fieldName, (Object)pattern);
        return query;
    }

    public BasicDBObject createOrDBObject(BasicDBObject ... andBasicDBObject) {
        return new BasicDBObject("$or", Arrays.asList(andBasicDBObject));
    }

    public DBObject queryOr(Map<String, Object> queryFilter) {
        QueryBuilder query = new QueryBuilder();
        for (Map.Entry<String, Object> entry : queryFilter.entrySet()) {
            query.or(new DBObject[]{new BasicDBObject(entry.getKey(), entry.getValue())});
        }
        return query.get();
    }

    @Override
    public List<Map<String, Object>> queryOrgTeachersWithIds(Integer orgId, Collection<Long> teacherIds, Boolean ... isIdQuery) {
        boolean isId = GenericsUtils.notNullAndEmpty((Object)isIdQuery) ? isIdQuery[0] : true;
        String queryField = isId ? "orgTeacherId" : "teacherUserId";
        BasicDBObject createAndDBObject = this.createAndDBObject(this.createRegex("id", "t_*"), this.createEqulas("orgId", orgId), this.createIn(queryField, teacherIds));
        log.info("query with createAndDBObject :{} ", (Object)createAndDBObject.toJson());
        List<Map<String, Object>> searchObjs = this.mongoDBOperator.searchObjs("orgTeacherDocuments", (Map<String, ? extends Object>)createAndDBObject.toMap(), Map.class, new Gson[0]);
        log.info("searchObjs is:{} ", searchObjs);
        return searchObjs;
    }
}

