/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.article.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.article.ArticleBaseInfoDao;
import com.baijia.tianxiao.dal.activity.mongo.MongoTemplate;
import com.baijia.tianxiao.dal.activity.po.ArticleBaseInfo;
import com.baijia.tianxiao.dal.activity.po.ArticleDetail;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.Block;
import com.mongodb.DBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ArticleBaseInfoDaoImpl
implements ArticleBaseInfoDao {
    private static final Logger log = LoggerFactory.getLogger(ArticleBaseInfoDaoImpl.class);
    private static final String COLLECTION = "article";

    @Override
    public List<ArticleBaseInfo> findArticleBaseInfoListByPage(int type, PageDto pageDto) {
        long totalCount = MongoTemplate.getConnection(COLLECTION).count();
        int first = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"category", (Object)type);
        query.put((Object)"articleImg", (Object)new Document("$exists", (Object)1));
        FindIterable iterable = MongoTemplate.getConnection(COLLECTION).find((Bson)query).skip(first).sort((Bson)new Document("pushTime", (Object)-1)).limit(pageDto.getPageSize().intValue());
        pageDto.setCount(Integer.valueOf((int)totalCount));
        final ArrayList<ArticleBaseInfo> list = new ArrayList<ArticleBaseInfo>();
        iterable.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                ArticleBaseInfo baseInfo = new ArticleBaseInfo();
                ArticleBaseInfoDaoImpl.this.parseDocument(document, baseInfo);
                list.add(baseInfo);
            }
        });
        return list;
    }

    @Override
    public Map<String, ArticleDetail> findArticleBaseInfoListByIds(List<String> ids) {
        if (ids == null || ids.size() < 1) {
            return Collections.emptyMap();
        }
        List objectIds = CollectionUtils.extractList(ids, (CollectionUtils.Extracter)new CollectionUtils.Extracter<ObjectId, String>(){

            public ObjectId extract(String s) {
                log.info("[ObjectId] ObjectId===" + s);
                return new ObjectId(s);
            }
        });
        FindIterable iterable = MongoTemplate.getConnection(COLLECTION).find(Filters.in((String)"_id", (Iterable)objectIds));
        final ArrayList list = new ArrayList();
        iterable.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                ArticleDetail detail = new ArticleDetail();
                ArticleBaseInfoDaoImpl.this.parseDocument(document, detail);
                detail.setContent(document.getString((Object)"content"));
                list.add(detail);
            }
        });
        Map<String, ArticleDetail> map = new HashMap<String, ArticleDetail>();
        if (list != null && list.size() > 0) {
            map = CollectionUtils.extractMap(list, (CollectionUtils.Extracter)new CollectionUtils.Extracter<String, ArticleDetail>(){

                public String extract(ArticleDetail articleBaseInfo) {
                    return articleBaseInfo.getId();
                }
            });
        }
        return map;
    }

    @Override
    public ArticleDetail findArticleDetailById(String id) {
        final ArticleDetail detail = new ArticleDetail();
        FindIterable iterable = MongoTemplate.getConnection(COLLECTION).find(Filters.eq((String)"_id", (Object)new ObjectId(id)));
        iterable.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                ArticleBaseInfoDaoImpl.this.parseDocument(document, detail);
                detail.setContent(document.getString((Object)"content"));
            }
        });
        return detail;
    }

    @Override
    public ArticleBaseInfo findArticleBaseInfoById(String id) {
        FindIterable iterable = MongoTemplate.getConnection(COLLECTION).find(Filters.eq((String)"_id", (Object)new ObjectId(id)));
        final ArticleBaseInfo baseInfo = new ArticleBaseInfo();
        iterable.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                if (document != null) {
                    ArticleBaseInfoDaoImpl.this.parseDocument(document, baseInfo);
                }
            }
        });
        return baseInfo;
    }

    private ArticleBaseInfo parseDocument(Document document, ArticleBaseInfo baseInfo) {
        baseInfo.setId(document.getObjectId((Object)"_id").toHexString());
        baseInfo.setAbstractContent(document.getString((Object)"abstractContent"));
        baseInfo.setArticleImg(document.getString((Object)"articleImg"));
        baseInfo.setArticleTitle(document.getString((Object)"articleTitle"));
        baseInfo.setCategory(document.getInteger((Object)"category"));
        baseInfo.setArticleUrl(document.getString((Object)"articleUrl"));
        baseInfo.setPushTime(document.getString((Object)"pushTime"));
        try {
            baseInfo.setThumbUpCount(String.valueOf(document.getInteger((Object)"thumbUpCount")));
        }
        catch (ClassCastException e) {
            baseInfo.setThumbUpCount(document.getString((Object)"thumbUpCount"));
        }
        try {
            baseInfo.setVisitCount(String.valueOf(document.getInteger((Object)"visitCount")));
        }
        catch (ClassCastException e) {
            baseInfo.setVisitCount(document.getString((Object)"visitCount"));
        }
        baseInfo.setThumbUpRate(document.getString((Object)"thumbUpRate"));
        baseInfo.setAuthor(document.getString((Object)"author"));
        return baseInfo;
    }

    @Override
    public void updateArticle(ArticleBaseInfo abi) {
        MongoTemplate.getConnection(COLLECTION).updateOne((Bson)new Document("_id", (Object)new ObjectId(abi.getId())), (Bson)new Document("$set", (Object)new Document("articleImg", (Object)abi.getArticleImg())));
    }

    @Override
    public void insertArticles(List<ArticleBaseInfo> articles) {
        ArrayList insert = Lists.newArrayList();
        Gson gson = new Gson();
        for (ArticleBaseInfo obj : articles) {
            DBObject parse = (DBObject)JSON.parse((String)gson.toJson((Object)obj));
            InsertOneModel e = new InsertOneModel((Object)new Document(parse.toMap()));
            insert.add(e);
        }
        MongoCollection<Document> connection = MongoTemplate.getConnection(COLLECTION);
        BulkWriteOptions options = new BulkWriteOptions();
        options.ordered(false);
        try {
            connection.bulkWrite((List)insert, options);
        }
        catch (Exception e) {
            log.info("encount a error : {} ", e.getCause());
        }
    }
}

