/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.es.dao.impl;

import com.baijia.tianxiao.dal.es.constant.EsClientConfig;
import com.baijia.tianxiao.dal.es.dao.EsBaseDao;
import com.baijia.tianxiao.dal.es.exceptions.EsException;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEsBaseDao
implements EsBaseDao {
    private static final Logger log = LoggerFactory.getLogger(AbstractEsBaseDao.class);
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    private static volatile TransportClient transportClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TransportClient getClient() {
        if (null != transportClient) return transportClient;
        Class<AbstractEsBaseDao> clazz = AbstractEsBaseDao.class;
        synchronized (AbstractEsBaseDao.class) {
            if (null != transportClient) return transportClient;
            long time = System.currentTimeMillis();
            Settings settings = Settings.builder().put("cluster.name", EsClientConfig.clusterNameString).build();
            PreBuiltTransportClient creatingClient = new PreBuiltTransportClient(settings, new Class[0]);
            for (Map.Entry<String, Integer> entry : EsClientConfig.getAddressList()) {
                try {
                    creatingClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(entry.getKey()), entry.getValue().intValue()));
                }
                catch (UnknownHostException e) {
                    log.error("[AbstractEsBaseDao] invalide ip or port, and ignored! ip:{}, port:{}", (Object)entry.getKey(), (Object)entry.getValue());
                }
            }
            log.info("[{}] init transportClient done! costs:{}ms", (Object)this.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - time));
            transportClient = creatingClient;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return transportClient;
        }
    }

    @Override
    public void createIndex(String index, int numberOfShards, int numberOfReplicas) {
        try {
            CreateIndexResponse createIndexResponse = (CreateIndexResponse)this.getClient().admin().indices().prepareCreate(index).setSettings(Settings.builder().put("number_of_shards", numberOfShards).put("number_of_replicas", numberOfReplicas).build()).get();
            log.warn("[{}] create es index:{} with {} Shards, {} Replicas result:{}", new Object[]{this.getClass().getSimpleName(), index, numberOfShards, numberOfReplicas, createIndexResponse.isAcknowledged()});
        }
        catch (Exception e) {
            log.error("[{}] create es index:{} with {} Shards, {} Replicas error! e:{}", new Object[]{this.getClass().getSimpleName(), index, numberOfShards, numberOfReplicas, e});
            throw new EsException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, e.getMessage());
        }
    }

    @Override
    public void deleteIndex(String index) {
        try {
            DeleteIndexResponse deleteIndexResponse = (DeleteIndexResponse)this.getClient().admin().indices().prepareDelete(new String[]{index}).get();
            log.warn("[{}] delete es index:{} result:{}", new Object[]{this.getClass().getSimpleName(), index, deleteIndexResponse.isAcknowledged()});
        }
        catch (Exception e) {
            log.error("[{}] delete es index:{} error! e:{}", new Object[]{this.getClass().getSimpleName(), index, e});
            throw new EsException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, e.getMessage());
        }
    }
}

