
package com.baijia.tianxiao.dal.club.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.club.dao.OrgVipDao;
import com.baijia.tianxiao.dal.club.po.OrgVip;
import com.baijia.tianxiao.dal.constant.VipStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class OrgVipDaoImpl extends JdbcTemplateDaoSupport<OrgVip> implements OrgVipDao {

    public OrgVipDaoImpl() {
        super(OrgVip.class);
    }

    @Override
    public OrgVip getNormalOrgVip(Integer id) {
        SingleSqlBuilder<OrgVip> builder = createSqlBuilder();
        builder.gt("id", id);
        builder.gt("remainDay", 0);
        builder.eq("status", VipStatus.NORMAL.getCode());
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(1);
        pageDto.setPageSize(1);
        builder.setPage(pageDto);
        return uniqueResult(builder);
    }

    @Override
    public OrgVip getLastOrgVip() {
        SingleSqlBuilder<OrgVip> builder = createSqlBuilder();
        builder.desc("id");
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(1);
        pageDto.setPageSize(1);
        builder.setPage(pageDto);
        return uniqueResult(builder);
    }

    @Override
    public List<OrgVip> getByOrgNumber(Integer orgNumber) {
        SingleSqlBuilder<OrgVip> builder = createSqlBuilder();
        builder.eq("status", VipStatus.NORMAL.getCode());
        builder.eq("org_number", orgNumber);
        return queryList(builder);
    }
    
    @Override
    public List<OrgVip> getTotalByOrgNumber(Integer orgNumber) {
        SingleSqlBuilder<OrgVip> builder = createSqlBuilder();
        builder.eq("org_number", orgNumber);
        return queryList(builder);
    }

}

    