package com.baijia.tianxiao.dal.cas.po;
import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

@Entity(dataSourceBeanName = "casDataSource")
@Table(name = "role", catalog = "cas")
public final class Role implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = -6727153657683062511L;
    private int id;
    private String name;
    /**
     * 角色类型
     * 0：普通角色
     * 1：超级管理员，可以管理所有角色
     * 2：普通管理员，按管辖关系管理
     */
    private Integer type;
    private Date createtime;
    private Date updatetime;
    /**
     * 角色启用状态
     * 0：正常启用
     * 1：已停用
     */
    private Integer status;
    private String comment;
    private Integer appId;
    /**
     * 角色唯一标识的字符串
     */
    private String tag;
    private Integer parentRoleId;


    @Id
    @Column(name = "id")
    @GeneratedValue
    public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}
    
    
	@Column
    public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column
	public Date getCreatetime() {
		return createtime;
	}

	public void setCreatetime(Date createtime) {
		this.createtime = createtime;
	}

	@Column
	public Date getUpdatetime() {
		return updatetime;
	}

	public void setUpdatetime(Date updatetime) {
		this.updatetime = updatetime;
	}

	@Column
	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	@Column
	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	@Column(name = "app_id")
	public Integer getAppId() {
		return appId;
	}

	public void setAppId(Integer appId) {
		this.appId = appId;
	}

	@Column
	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}
	
	@Column(name = "parent_role_id")
	public Integer getParentRoleId() {
		return parentRoleId;
	}

	public void setParentRoleId(Integer parentRoleId) {
		this.parentRoleId = parentRoleId;
	}
	
	
	@Column(name = "type")
	public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    

	@Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
