package com.baijia.tianxiao.dal.cas.po;
import java.util.Date;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

@Entity(dataSourceBeanName = "casDataSource")
@Table(name = "account_role", catalog = "cas")
@Data
public final class AccountRole {
    @Id
    @GeneratedValue
    private int id;
    @Column(name = "app_id")
    private Integer appId;
    @Column(name = "account_id")
    private Integer accountId;
    @Column(name = "role_id")
    private Integer roleId;
    @Column(name = "parent_id")
    private Integer parentId;
    @Column(name = "parent_account_id")
    private Integer parentAccountId;
    @Column(name = "parent_role_id")
    private Integer parentRoleId;
    @Column(name = "createtime")
    private Date createtime;
    @Column(name = "authorize_id")
    private Integer authorizeId;
    @Column(name = "authorize_account_id")
    private Integer authorizeAccountId;
    @Column(name = "authorize_role_id")
    private Integer authorizeRoleId;
    @Column(name = "nick_name")
    private String nickName;
    @Column(name = "status")
    private Integer status;

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

	@Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
