
package com.baijia.tianxiao.dal.shoukuan.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.constant.DalConstant;
import com.baijia.tianxiao.dal.shoukuan.dao.SuccessOrderInfoDao;
import com.baijia.tianxiao.dal.shoukuan.po.SuccessOrderInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class SuccessOrderInfoDaoImpl extends JdbcTemplateDaoSupport<SuccessOrderInfo> implements SuccessOrderInfoDao {

    public SuccessOrderInfoDaoImpl() {
        super(SuccessOrderInfo.class);
    }

    @Override
    public List<SuccessOrderInfo> getPayedOrderInfoByIndex(Integer id) {
        SingleSqlBuilder<SuccessOrderInfo> builder = createSqlBuilder();
        builder.gt("id", id);
        builder.eq("type", DalConstant.ORDER_INFO_JIGOU_TYPE);
        builder.eq("subType", DalConstant.ORDER_INFO_JIGOU_HUIYUAN_SUB_TYPE);
        builder.asc("id");
        return queryList(builder, SuccessOrderInfo.class);
    }

    @Override
    public List<SuccessOrderInfo> getPayedOrderInfoByIndex(Integer type, Integer subType, Integer id) {
        SingleSqlBuilder<SuccessOrderInfo> builder = createSqlBuilder();
        builder.gt("id", id);
        builder.eq("type", type);
        builder.eq("subType", subType);
        builder.asc("id");
        return queryList(builder, SuccessOrderInfo.class);
    }

}

    