
package com.baijia.tianxiao.dal.cas.dao.impl;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.cas.dao.AccountRoleDao;
import com.baijia.tianxiao.dal.cas.po.AccountRole;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class AccountRoleDaoImpl extends JdbcTemplateDaoSupport<AccountRole> implements AccountRoleDao {

    public AccountRoleDaoImpl() {
        super(AccountRole.class);
    }

    @Override
    public List<AccountRole> getRolesByAccountId(Integer accountId) {
        SingleSqlBuilder<AccountRole> builder = createSqlBuilder();
        builder.eq("accountId", accountId);
        return queryList(builder);
    }

    @Override
    public void updateAccountRoleStatus(Integer id, Integer status) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("status", status);
        params.put("id", id);
        StringBuilder sql = new StringBuilder();
        sql.append("update cas.account set ").append("status=:status ").append("where id = :id");
        new SqlParameterSourceUtils();
        this.getNamedJdbcTemplate().update(sql.toString(), params);
    }
}

    