/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseDaoImpl
extends JdbcTemplateDaoSupport<OrgCourse>
implements OrgCourseDao {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseDaoImpl.class);

    public OrgCourseDaoImpl() {
        super(OrgCourse.class);
    }

    @Override
    public List<OrgCourse> getCoursesByOrgNumber(Long orgNumber, String key, Integer status, Integer isCourse, Integer isClass, Integer courseType, PageDto page, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            builder.like("name", (Serializable)((Object)key), MatchMode.ANYWHERE);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        if (page != null) {
            builder.setPage(page);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.desc("beginTime");
        return this.queryList(builder);
    }

    private void buildCourseType(SingleSqlBuilder<OrgCourse> builder, Integer isCourse, Integer isClass, Integer courseType) {
        if (isCourse != null) {
            builder.eq("isCourse", (Serializable)isCourse);
        }
        if (isClass != null) {
            builder.eq("isClass", (Serializable)isClass);
        }
        if (courseType != null) {
            builder.eq("courseType", (Serializable)courseType);
        }
    }

    @Override
    public List<OrgCourse> getCoursesByOrgNumberAndName(Long orgNumber, String key, Integer status, Integer isCourse, Integer isClass, Integer courseType, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            builder.eq("name", (Serializable)((Object)key));
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        if (page != null) {
            builder.setPage(page);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.desc("beginTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourse> getCoursesByOrgNumberAndNames(Long orgNumber, List<String> courseNames, Integer status, Integer isCourse, Integer isClass, Integer courseType, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (CollectionUtils.isNotEmpty(courseNames)) {
            builder.in("name", courseNames);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        if (page != null) {
            builder.setPage(page);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.desc("beginTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourse> getCourseList(Long orgNumber, Collection<Long> courseIds, String key, Integer status, Date startTime, Date endTime, Integer isCourse, Integer isClass, Integer courseType, PageDto page, String ... queryProp) {
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        param.setKey(key);
        param.setStatus(status);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setIsCourse(isCourse);
        param.setOrderField("createTime");
        param.setOrderType("DESC");
        param.setIsClass(isClass);
        param.setCourseType(courseType);
        param.setPage(page);
        return this.getCourseList(orgNumber, courseIds, param, queryProp);
    }

    @Override
    public List<OrgCourse> getCourseList(Integer cascadeId, Long orgNumber, Collection<Long> courseIds, String key, Integer status, Date startTime, Date endTime, Integer isCourse, Integer isClass, Integer courseType, PageDto page, String ... queryProp) {
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        param.setKey(key);
        param.setStatus(status);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setIsCourse(isCourse);
        param.setIsClass(isClass);
        param.setCourseType(courseType);
        param.setPage(page);
        if (cascadeId != null) {
            param.setCascadeId(cascadeId);
        }
        return this.getCourseList(orgNumber, courseIds, param, queryProp);
    }

    @Override
    public List<Long> getCourseIds(Long orgNumber, Integer status, Integer isCourse, Integer isClass, Integer courseType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        List courses = this.queryList(builder);
        ArrayList resultList = Lists.newArrayList();
        for (OrgCourse course : courses) {
            resultList.add(course.getId());
        }
        return resultList;
    }

    @Override
    public List<Long> getCourseList(Long orgNumber, Collection<Long> courseIds, String key, Integer status, Integer isCourse, Integer isClass, Integer courseType) {
        if (courseIds != null && CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            builder.like("name", (Serializable)((Object)key), MatchMode.ANYWHERE);
        }
        if (courseIds != null) {
            builder.in("id", courseIds);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        List courses = this.queryList(builder);
        ArrayList resultList = Lists.newArrayList();
        for (OrgCourse course : courses) {
            resultList.add(course.getId());
        }
        return resultList;
    }

    @Override
    public List<OrgCourse> getCoursesByCascadeIds(Long orgNumber, Collection<Long> cascadeIds, String key, Integer status, Integer isCourse, Integer isClass, Integer courseType) {
        if (cascadeIds != null && CollectionUtils.isEmpty(cascadeIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            builder.like("name", (Serializable)((Object)key), MatchMode.ANYWHERE);
        }
        if (cascadeIds != null) {
            builder.in("cascadeId", cascadeIds);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        return this.queryList(builder);
    }

    @Override
    public List<Long> getCourseList(Long orgNumber, Collection<Long> courseIds, Double lPrice, Double hPrice, Collection<Long> subjectIds, String key, Integer status, Integer isCourse, Integer isClass, Integer courseType) {
        if (courseIds != null && CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            builder.like("name", (Serializable)((Object)key), MatchMode.ANYWHERE);
        }
        if (courseIds != null) {
            builder.in("id", courseIds);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        if (lPrice != null) {
            builder.ge("price", (Serializable)lPrice);
        }
        if (hPrice != null) {
            builder.le("price", (Serializable)hPrice);
        }
        if (subjectIds != null) {
            builder.in("subjectId", subjectIds);
        }
        builder.desc("beginTime");
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        List courses = this.queryList(builder);
        ArrayList resultList = Lists.newArrayList();
        for (OrgCourse course : courses) {
            resultList.add(course.getId());
        }
        return resultList;
    }

    @Override
    public List<OrgCourse> getCourseList(Long orgNumber, Collection<Long> courseIds, OrgCourseDao.OrgCourseListParam param, String ... queryProp) {
        log.debug("*********orgNumber:{},courseIds:{},param={}", new Object[]{orgNumber, courseIds, param});
        if (courseIds != null && CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (StringUtils.isNotEmpty((CharSequence)param.getKey())) {
            builder.like("name", (Serializable)((Object)param.getKey()), MatchMode.ANYWHERE);
        }
        if (param.getCascadeId() != null && param.getCascadeId() > 0) {
            builder.eq("cascadeId", (Serializable)param.getCascadeId());
        }
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("id", courseIds);
        }
        if (param.getStatus() != null) {
            builder.eq("status", (Serializable)param.getStatus());
        }
        if (param.getStartTime() != null) {
            builder.ge("createTime", (Serializable)param.getStartTime());
        }
        if (param.getEndTime() != null) {
            builder.le("createTime", (Serializable)param.getEndTime());
        }
        if (param.getPage() != null) {
            builder.setPage(param.getPage());
        }
        if (param.getCourseType() != null) {
            builder.eq("courseType", (Serializable)param.getCourseType());
        }
        if (param.getIsCourse() != null) {
            builder.eq("isCourse", (Serializable)param.getIsCourse());
        }
        if (param.getIsClass() != null) {
            builder.eq("isClass", (Serializable)param.getIsClass());
        }
        if (param.getQueryCondition() != null) {
            builder.add(param.getQueryCondition());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{param.getOrderField(), param.getOrderType()})) {
            if (param.getOrderType().equals("DESC")) {
                builder.desc(param.getOrderField(), param.getOrderField().equals("name"));
            } else if (param.getOrderType().equals("ASC")) {
                builder.asc(param.getOrderField(), param.getOrderField().equals("name"));
            }
        }
        builder.eq("isDel", (Serializable)param.getIsDel());
        log.debug("course list\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0dsql={},param={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public Map<Long, OrgCourse> getOrgCourseMap(Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        List courses = this.getByIds(courseIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)courses)) {
            HashMap result = Maps.newHashMap();
            for (OrgCourse course : courses) {
                result.put(course.getId(), course);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<Long> getCourseIdsByOrgNumberAndCourseName(Long orgNumber, String name, Integer status, Integer isCourse, Integer isClass, Integer courseType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("id");
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.like("name", (Serializable)((Object)name), MatchMode.ANYWHERE);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgCourse> getCourseByOrgNumberAndCourseName(Long orgNumber, String name, Integer status, Collection<Long> courseIds, Integer isCourse, Integer isClass, Integer courseType, Integer limit) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.like("name", (Serializable)((Object)name), MatchMode.ANYWHERE);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        if (courseIds != null) {
            builder.in("id", courseIds);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.eq("isClass", (Serializable)Integer.valueOf(1));
        builder.setMaxSize(limit);
        builder.desc("createTime");
        List list = this.queryList(builder);
        log.debug("list = {}", (Object)list);
        return list;
    }

    @Override
    public OrgCourse getByCourseId(Long orgCourseId, String ... queryProp) {
        return (OrgCourse)this.getById(orgCourseId, queryProp);
    }

    @Override
    public OrgCourse getByCourseNumber(Long orgCourseNumber, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("number", (Serializable)orgCourseNumber);
        return (OrgCourse)this.uniqueResult(builder);
    }

    @Override
    public List<OrgCourse> getByIdsOrderByIn(Collection<Long> courseIds, Integer limit) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ne("status", (Serializable)Integer.valueOf(1));
        builder.in("id", courseIds);
        builder.setMaxSize(limit);
        List list = this.queryList(builder);
        log.debug("list = {}", (Object)list);
        return list;
    }

    @Override
    public int getValidOrgCourseCount(Integer orgNumber, Integer isCourse, Integer isClass, Integer courseType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("status", (Serializable)Integer.valueOf(0));
        builder.eq("verifyStatus", (Serializable)Integer.valueOf(1));
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (null != isCourse) {
            builder.eq("is_course", (Serializable)isCourse);
        }
        if (null != isClass) {
            builder.eq("is_class", (Serializable)isClass);
        }
        if (null != courseType) {
            builder.eq("course_type", (Serializable)courseType);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Map<Long, String> getCourseNameMap(Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        MapBatchQueryTemplate queryTemplate = new MapBatchQueryTemplate();
        return (Map)queryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, String>>(){

            public Map<Long, String> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseDaoImpl.this.createSqlBuilder(new String[]{"id", "name"});
                builder.in("id", querySet);
                List courses = OrgCourseDaoImpl.this.queryList(builder);
                return CollectorUtil.collectMap((Collection)courses, (Function)new Function<OrgCourse, Long>(){

                    public Long apply(OrgCourse from) {
                        return from.getId();
                    }
                }, (Function)new Function<OrgCourse, String>(){

                    public String apply(OrgCourse from) {
                        return from.getName();
                    }
                });
            }
        });
    }

    @Override
    @Deprecated
    public Map<Integer, Integer> allCourseOrgIdMap() {
        HashMap param = new HashMap();
        String sql = "select  c.id as c_course_id ,a.id as c_org_id  from cdb.org_course c,yunying.org_account a where a.number = c. organization_number";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Integer, Integer>>(){

            public Map<Integer, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                while (rs.next()) {
                    Integer courseId = rs.getInt("c_course_id");
                    Integer orgId = rs.getInt("c_org_id");
                    map.put(courseId, orgId);
                }
                return map;
            }
        });
    }

    @Override
    public OrgCourse getCourseByCourseNumberAndOrgNumber(Long orgNumber, Long courseNumber, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("number", (Serializable)courseNumber);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        return (OrgCourse)this.uniqueResult(builder);
    }

    @Override
    public List<OrgCourse> getOrgCourseList(Long orgNumber, Collection<Long> courseNumbers) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.in("number", courseNumbers);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        return this.queryList(builder);
    }

    @Override
    public List<Integer> getOrgCourseSubjectIds(Integer orgNumber, Integer isCourse, Integer isClass, Integer courseType) {
        String sql = "select distinct subject_id from cdb.org_course where status=0 and organization_number=? ";
        if (null != isCourse) {
            sql = sql + " and is_course=? ";
        }
        if (null != isClass) {
            sql = sql + " and is_class=? ";
        }
        if (null != courseType) {
            sql = sql + " and course_type=? ";
        }
        List subjectIds = this.getNamedJdbcTemplate().getJdbcOperations().query(sql, new Object[]{orgNumber}, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getInt("subject_id");
            }
        });
        return subjectIds;
    }

    @Override
    public List<Long> getCourseNumberByOrg(Long orgNumber, Integer isCourse, Integer isClass, Integer courseType) {
        String sql = "select number from cdb.org_course where status=0 and is_del=0 and organization_number=? ";
        if (null != isCourse) {
            sql = sql + " and is_course=? ";
        }
        if (null != isClass) {
            sql = sql + " and is_class=? ";
        }
        if (null != courseType) {
            sql = sql + " and course_type=? ";
        }
        List numbers = this.getNamedJdbcTemplate().getJdbcOperations().query(sql, new Object[]{orgNumber}, (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getLong("number");
            }
        });
        return numbers;
    }

    @Override
    public List<Long> getCourseIdsByCourseNumberAndOrgNumber(final Long orgNumber, Collection<Long> courseNumbers, Integer courseType) {
        if (CollectionUtils.isEmpty(courseNumbers)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(courseNumbers, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseDaoImpl.this.createSqlBuilder(new String[]{"id"});
                builder.eq("orgNumber", (Serializable)orgNumber);
                builder.in("number", querySet);
                builder.eq("isDel", (Serializable)Integer.valueOf(0));
                return OrgCourseDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public List<OrgCourse> getAndFilterOrgCourse(Integer orgNumber, Collection<Long> excludeIds, Integer isCourse, Integer isClass, Integer courseType, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("status", (Serializable)Integer.valueOf(0));
        if (excludeIds != null && !excludeIds.isEmpty()) {
            builder.notin("id", excludeIds);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourse> getAndFilterOrgCourseByIn(Integer orgNumber, Collection<Long> includeIds, Integer isCourse, Integer isClass, Integer courseType, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("status", (Serializable)Integer.valueOf(0));
        builder.in("id", includeIds);
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.setPage(pageDto);
        builder.desc("createTime");
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourse> getAndFilterOrgCourseByIn(Integer orgNumber, Collection<Long> includeIds, Integer status, Integer isCourse, Integer isClass, Integer courseType, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.in("id", includeIds);
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.setPage(pageDto);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public int getValidOrgCourseCount(Integer orgNumber, Collection<Long> ids) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("id", ids);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("status", (Serializable)Integer.valueOf(0));
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public void changeCourseColor(Integer orgNumber, Long courseId, String color) {
        OrgCourse course = this.getByCourseId(courseId, new String[0]);
        if (course == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "course not found!");
        }
        course.setColor(color);
        this.update(course, new String[0]);
    }

    @Override
    public void changeCourseColor(Collection<OrgCourse> courses) {
        if (CollectionUtils.isNotEmpty(courses)) {
            ArrayList batchs = Lists.newArrayList();
            for (OrgCourse orgCourse : courses) {
                HashMap map = Maps.newHashMap();
                map.put("color", orgCourse.getColor());
                map.put("id", orgCourse.getId());
                batchs.add(map);
            }
            String sql = "update cdb.org_course set color =:color where id=:id";
            this.getNamedJdbcTemplate().batchUpdate(sql, (Map[])batchs.toArray(new HashMap[courses.size()]));
        }
    }

    @Override
    public String getCourseNameById(Long orgCourseId) {
        OrgCourse course = this.getByCourseId(orgCourseId, "name");
        if (course != null) {
            return course.getName();
        }
        return null;
    }

    @Override
    public List<OrgCourse> getVisualOrgCourseByOrgNumber(Integer orgNumber, String subjectIds, int orderType, Integer isCourse, Integer isClass, Integer courseType) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgNumber", orgNumber);
        String sql = "SELECT id,number,name,subject_id,rank,extend_status,transform,page_view FROM cdb.org_course where organization_number=:orgNumber and status=0  and is_del=0 ";
        if (StringUtils.isNotEmpty((CharSequence)subjectIds)) {
            String[] subArray = StringUtils.split((String)subjectIds, (String)"|");
            ArrayList subjectList = Lists.newArrayList();
            for (String s : subArray) {
                subjectList.add(Integer.valueOf(s));
            }
            paramMap.put("subjectIds", subjectList);
            sql = sql + " and subject_id in(:subjectIds) ";
        }
        if (null != isCourse) {
            paramMap.put("isCourse", isCourse);
            sql = sql + " and is_course=:isCourse ";
        }
        if (null != isClass) {
            paramMap.put("isClass", isClass);
            sql = sql + " and is_class=:isClass ";
        }
        if (null != courseType) {
            paramMap.put("courseType", courseType);
            sql = sql + " and course_type=:courseType  ";
        }
        if (orderType == 0) {
            sql = sql + " order by extend_status desc, rank desc ";
        } else if (orderType == 1) {
            sql = sql + " order by rank desc ";
        } else if (orderType == 2) {
            sql = sql + " order by rank asc ";
        } else if (orderType == 3) {
            sql = sql + " order by page_view desc ";
        } else if (orderType == 4) {
            sql = sql + " order by page_view asc ";
        } else if (orderType == 5) {
            sql = sql + " order by transform desc ";
        } else if (orderType == 6) {
            sql = sql + " order by transform asc ";
        }
        log.info("orgCourseQuery,sql=" + sql);
        final ArrayList result = Lists.newArrayList();
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<List<OrgCourse>>(){

            public List<OrgCourse> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    OrgCourse orgCourse = new OrgCourse();
                    orgCourse.setId(rs.getLong("id"));
                    orgCourse.setNumber(rs.getLong("number"));
                    orgCourse.setName(rs.getString("name"));
                    orgCourse.setSubjectId(rs.getInt("subject_id"));
                    orgCourse.setRank(rs.getInt("rank"));
                    orgCourse.setExtendStatus(rs.getInt("extend_status"));
                    orgCourse.setTransform(rs.getInt("transform"));
                    orgCourse.setPageView(rs.getInt("page_view"));
                    result.add(orgCourse);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public OrgCourse getOrgCourse(Integer orgNumber, Long courseNum) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("number", (Serializable)courseNum);
        return (OrgCourse)this.uniqueResult(builder);
    }

    @Override
    public int getAdvertiseCourseCount(Integer orgNumber, Integer isCourse, Integer isClass, Integer courseType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.eq("extendStatus", (Serializable)Integer.valueOf(1));
        builder.count("id");
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        Integer result = (Integer)this.queryForObject(builder, Integer.class);
        if (result == null) {
            return 0;
        }
        return result;
    }

    @Override
    public int getMaxId() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.max("id");
        Integer maxId = (Integer)this.queryForObject(builder, Integer.class);
        if (maxId != null) {
            return maxId;
        }
        return 0;
    }

    @Override
    public List<OrgCourse> getCourseList(Collection<Long> courseIds, Long orgNumber, Integer isCourse, Integer isClass, Integer courseType, PageDto page, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.in("id", courseIds);
        if (page != null) {
            builder.setPage(page);
        }
        if (orgNumber != null) {
            builder.eq("orgNumber", (Serializable)orgNumber);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<String> getBlobString(Long orgNumber, Long courseNumber) {
        String sql = "SELECT introduction FROM cdb.org_course where organization_number=:orgNumber and number=:courseNumber";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgNumber", orgNumber);
        paramMap.put("courseNumber", courseNumber);
        DefaultLobHandler lobHandler = new DefaultLobHandler();
        return this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (RowMapper)new RowMapper<String>((LobHandler)lobHandler){
            final /* synthetic */ LobHandler val$lobHandler;
            {
                this.val$lobHandler = lobHandler;
            }

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                byte[] bytes = this.val$lobHandler.getBlobAsBytes(rs, 1);
                if (bytes != null) {
                    String s = new String(bytes);
                    return s;
                }
                return null;
            }
        });
    }

    @Override
    public void repairNumber() {
        String sql = "select id,number from cdb.org_course where length(number)>10";
        List list = this.getNamedJdbcTemplate().query(sql, (RowMapper)new RowMapper<OrgCourse>(){

            public OrgCourse mapRow(ResultSet rs, int rowNum) throws SQLException {
                OrgCourse orgCourse = new OrgCourse();
                orgCourse.setNumber(rs.getLong("number"));
                orgCourse.setId(rs.getLong("id"));
                return orgCourse;
            }
        });
        int count = 0;
        for (OrgCourse course : list) {
            long number = SerialNumberUtil.generateNumber(course.getId().intValue(), 99999999, 4);
            if (course.getNumber().equals(number)) continue;
            course.setNumber(number);
            this.saveOrUpdate(course, new String[]{"number"});
            ++count;
        }
        log.info("repair {} records.", (Object)count);
    }

    @Override
    public Map<Integer, Integer> getCourseTotal(Date startTime, Date endTime, List<Integer> TianxiaoOrgNumbers, Integer isCourse, Integer isClass, Integer courseType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgNumbers", TianxiaoOrgNumbers);
        StringBuilder sb = new StringBuilder();
        sb.append("select organization_number, count(id) count from cdb.org_course where organization_number in (:orgNumbers)");
        if (isCourse != null) {
            param.put("isCourse", isCourse);
            sb.append(" and is_course= :isCourse");
        }
        if (isClass != null) {
            param.put("isClass", isClass);
            sb.append(" and is_class= :isClass");
        }
        if (courseType != null) {
            param.put("courseType", courseType);
            sb.append(" and course_type= :courseType");
        }
        if (startTime != null && endTime != null) {
            sb.append(" and create_time between :startTime and :endTime ");
            param.put("endTime", endTime);
            param.put("startTime", startTime);
        }
        sb.append(" group by organization_number");
        return (Map)this.getNamedJdbcTemplate().query(sb.toString(), param, (ResultSetExtractor)new ResultSetExtractor<Map<Integer, Integer>>(){

            public Map<Integer, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                while (rs.next()) {
                    Integer orgNamber = rs.getInt("organization_number");
                    Integer count = rs.getInt("count");
                    map.put(orgNamber, count);
                }
                return map;
            }
        });
    }

    @Override
    public Map<String, Integer> getCourseTotalMap(Date startTime, Date endTime, List<Integer> TianxiaoOrgNumbers, Integer isCourse, Integer isClass, Integer courseType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgNumbers", TianxiaoOrgNumbers);
        StringBuilder sb = new StringBuilder();
        sb.append("select count(id) count, DATE_FORMAT(create_time,'%y-%m-%d') createTime from cdb.org_course where organization_number in (:orgNumbers)");
        if (isCourse != null) {
            param.put("isCourse", isCourse);
            sb.append(" and is_course= :isCourse");
        }
        if (isClass != null) {
            param.put("isClass", isClass);
            sb.append(" and is_class= :isClass");
        }
        if (courseType != null) {
            param.put("courseType", courseType);
            sb.append(" and course_type= :courseType");
        }
        if (startTime != null && endTime != null) {
            sb.append(" and create_time between :startTime and :endTime ");
            param.put("endTime", endTime);
            param.put("startTime", startTime);
        }
        sb.append(" group by MONTH(create_time), DAY(create_time)");
        return (Map)this.getNamedJdbcTemplate().query(sb.toString(), param, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    String createTime = rs.getString("createTime");
                    Integer count = rs.getInt("count");
                    map.put(createTime, count);
                }
                return map;
            }
        });
    }

    @Override
    public void refreshOrgCourse(Long organizationNumber, Long id) {
        StringBuilder sb = new StringBuilder("update cdb.org_course set is_del =1 where id > :id and  organization_number = :organizationNumber");
        HashMap param = Maps.newHashMap();
        param.put("organizationNumber", organizationNumber);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public List<OrgCourse> getOrgCourseList(Collection<Integer> orgNumbers, Integer isCourse, Integer isClass, Integer courseType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgNumber", orgNumbers);
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        List orgCourseList = this.queryList(builder);
        return orgCourseList;
    }

    @Override
    public List<OrgCourse> getNormalCourseList(Collection<Long> courseIds, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.in("id", courseIds);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourse> getCourseByCasCadeIds(Integer orgNumber, List<Integer> casCadeIds, Integer isCourse, Integer isClass, Integer courseType, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.in("cascadeId", casCadeIds);
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        return this.queryList(builder);
    }

    @Override
    public List<Long> getCourseIdsByCascadeId(Integer cascadeId, Integer isCourse, Integer isClass, Integer courseType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("cascadeId", (Serializable)cascadeId);
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)builder, isCourse, isClass, courseType);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.desc("createTime");
        ArrayList ids = Lists.newArrayList();
        List orgCourses = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                ids.add(orgCourse.getId());
            }
        }
        return ids;
    }

    @Override
    public OrgCourse getOrgCourse(Integer orgNumber, Long courseNum, Integer cascadeId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("number", (Serializable)courseNum);
        builder.eq("cascadeId", (Serializable)cascadeId);
        return (OrgCourse)this.uniqueResult(builder);
    }

    @Override
    public void batchUpdateHeadTeacher(Integer orgNumber, Integer oldCascadeId, Integer newCascadeId) {
        String sql = "update cdb.org_course set cascade_id=:newCascadeId where organization_number=:number and cascade_id=:oldCascadeId";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("number", orgNumber);
        map.put("oldCascadeId", oldCascadeId);
        map.put("newCascadeId", newCascadeId);
        log.info("[HeadTeacher] sql={},param={}", (Object)sql, map);
        this.getNamedJdbcTemplate().update(sql, map);
    }

    @Override
    public List<OrgCourse> searchCourses(Long number, Set<Long> filterIds, boolean allCourse, Integer isCourse, Integer isClass, Integer courseType, PageDto pageDto) {
        log.info("orgNumber is : {} ,filterIds is : {} ,isAllcourse is:{} ,pageDto is : {} ", new Object[]{number, filterIds, allCourse, pageDto});
        SingleSqlBuilder createSqlBuilder = this.createSqlBuilder(new String[0]);
        createSqlBuilder.eq("orgNumber", (Serializable)number);
        if (allCourse) {
            if (GenericsUtils.notNullAndEmpty(filterIds)) {
                createSqlBuilder.notin("id", filterIds);
            }
        } else {
            if (GenericsUtils.isNullOrEmpty(filterIds)) {
                return Collections.emptyList();
            }
            createSqlBuilder.in("id", filterIds);
        }
        this.buildCourseType((SingleSqlBuilder<OrgCourse>)createSqlBuilder, isCourse, isClass, courseType);
        if (pageDto != null) {
            createSqlBuilder.setPage(pageDto);
        }
        String sql = createSqlBuilder.toSql();
        log.info("sql is : {} ", (Object)sql);
        return this.queryList(createSqlBuilder);
    }

    @Override
    public List<OrgCourse> fuzzyQuery(Integer orgNumber, String courseName, Collection<Long> courseIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("id", courseIds);
        }
        builder.eq("isClass", (Serializable)Integer.valueOf(1));
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        if (StringUtils.isNotBlank((CharSequence)courseName)) {
            builder.like("name", (Serializable)((Object)courseName), MatchMode.ANYWHERE);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourse> fuzzyQueryByCourseType(Integer orgNumber, String courseName, Collection<Long> courseIds, Integer type, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("id", courseIds);
        }
        builder.eq("isClass", (Serializable)Integer.valueOf(1));
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        if (StringUtils.isNotBlank((CharSequence)courseName)) {
            builder.like("name", (Serializable)((Object)courseName), MatchMode.ANYWHERE);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourse> getCoursesByParentIds(Long orgNumber, List<Long> parentIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.in("parentId", parentIds);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        return this.queryList(builder);
    }

    @Override
    public List<Long> getClassIdsByParentId(Long parentId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("parentId", (Serializable)parentId);
        List courses = this.queryList(builder);
        return ListUtil.toKeyList((Collection)courses, (String)"id", OrgCourse.class);
    }

    @Override
    public void updateFinish(Long id, Integer isFinish) {
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put("id", id);
        updateCondtion.put("isFinish", isFinish);
        this.update(updateCondtion, new String[]{"isFinish"});
    }

    @Override
    public int getAllCourseCountByOrg(Long orgNumber) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("status", (Serializable)Integer.valueOf(0));
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.eq("isCourse", (Serializable)Integer.valueOf(1));
        builder.eq("orgNumber", (Serializable)orgNumber);
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public List<OrgCourse> getValidClassCourseCountsByIds(Integer number, List<Integer> orgCourseIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", orgCourseIds);
        builder.eq("orgNumber", (Serializable)number);
        builder.eq("status", (Serializable)Integer.valueOf(0));
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        return this.queryList(builder, OrgCourse.class);
    }
}

