/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public enum CourseTypeEnum {
    COURSE_TYPE_CLASS(1, "\u73ed\u8bfe"),
    COURSE_TYPE_1v1(2, "1\u5bf91"),
    COURSE_TYPE_NEW_CLASS(3, "\u73ed\u8bfe"),
    COURSE_TYPE_CLASS_LIVE(11, "\u76f4\u64ad\u8bfe"),
    COURSE_TYPE_CLASS_VIDEO(12, "\u89c6\u9891\u8bfe"),
    IS_COURSE_TRUE(1),
    IS_COURSE_FALSE(0),
    IS_CLASS_TRUE(1),
    IS_CLASS_FALSE(0);

    private Integer code;
    private String msg;

    private CourseTypeEnum(int code) {
        this.code = code;
    }

    private CourseTypeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static CourseTypeEnum getByCode(int code) {
        for (CourseTypeEnum p : CourseTypeEnum.values()) {
            if (p.getCode() != code) continue;
            return p;
        }
        return null;
    }

    public static boolean isOneToOne(Integer type) {
        return CourseTypeEnum.COURSE_TYPE_1v1.code.equals(type);
    }

    public static boolean isClassCourse(Integer type) {
        if (COURSE_TYPE_NEW_CLASS.getCode().intValue() == type.intValue()) {
            return true;
        }
        return COURSE_TYPE_CLASS.getCode().intValue() == type.intValue();
    }

    public static List<Integer> getCourseTypeList(Integer courseType) {
        if (courseType != null) {
            ArrayList result = Lists.newArrayList();
            if (courseType == COURSE_TYPE_CLASS.getCode() || courseType == COURSE_TYPE_NEW_CLASS.getCode()) {
                result.add(COURSE_TYPE_CLASS.getCode());
                result.add(COURSE_TYPE_NEW_CLASS.getCode());
            } else {
                result.add(courseType);
            }
            return result;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }
}

