/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.constant;

import com.baijia.tianxiao.dal.constant.ChargeUnit;

public enum ChargeMode {
    BY_OTHER(-1, "\u672a\u77e5"),
    BY_TIMES(1, "\u6309\u6b21"),
    BY_HOUR(2, "\u6309\u8bfe\u65f6");

    private Integer code;
    private String desc;

    private ChargeMode(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ChargeMode getChargeMode(ChargeUnit chargeUnit) {
        if (ChargeUnit.isByTime(chargeUnit.getCode())) {
            return BY_HOUR;
        }
        if (ChargeUnit.isByTimes(chargeUnit.getCode())) {
            return BY_TIMES;
        }
        return BY_OTHER;
    }

    public static ChargeMode getByCharegeUnit(Integer chargeUnit) {
        if (null == chargeUnit) {
            return BY_OTHER;
        }
        if (ChargeUnit.isByTime(chargeUnit)) {
            return BY_HOUR;
        }
        if (ChargeUnit.isByTimes(chargeUnit)) {
            return BY_TIMES;
        }
        return BY_OTHER;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

