/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年4月21日
 * @desc
 */
@Data
@Entity
@Table(name = "org_app_login_log", catalog = "cdb")
public class OrgAppLoginLog {
    @Id
    @GeneratedValue
    @Column(name = "id")
    private long id;
    @Column(name = "user_id")
    private long userId; // 用户编号
    @Column(name = "login_ip")
    private String loginIp; // 用户登录ip
    @Column(name = "tid")
    private int tid; // 登录来源：1 Android, 2 Iphone, 3 Ipad
    @Column(name = "channel")
    private String channel; // 渠道号
    @Column(name = "device")
    private String device; // 设备号
    @Column(name = "version")
    private String version; // 客户端版本号
    @Column(name = "mac")
    private String mac; // android的mac地址
    @Column(name = "imei")
    private String imei; // android的imei号
    @Column(name = "create_time")
    private Date createTime; // 用户登录时间

}
