package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface OrgCourseTeacherDao extends CommonDao<OrgCourseTeacher> {
    List<OrgCourseTeacher> getTeacher(Long orgId, Long courseId);

    public Integer getTeacherCourseCount(Long teacherId);

    public List<OrgCourseTeacher> getCourseTeachers(Long userId);

    // public List<OrgCourseTeacher> getCourseTeachers(Long courseId, Long userId);

    public List<String> getTeacherNames(Long courseId);

    public Map<Long, List<String>> getAllTeacherNames(Collection<Long> courseIds);

    public List<OrgCourseTeacher> getOrgCourseTeacher(Collection<Long> courseIds, PageDto pageDto);

    /**
     * 从课程老师关联表删除指定老师
     * 
     * @param courseId
     * @param teacherIds
     * @return
     */
    int delTeachersFromCourse(Long courseId, Collection<Long> teacherIds);

    /**
     * 获取课程老师ID map
     * 
     * @param courseIds
     * @param orgId
     * @return
     */
    Map<Long, List<Long>> getTeacherMap(Collection<Long> courseIds);

    /**
     * 根据老师id获取老师所带的课程
     * 
     * @param userId
     * @param orgId
     * @return
     */
    List<Long> getCourseIdByTeacherId(Long userId);

    /**
     * @param courseId
     * @return
     */
    List<Long> getTeacherIdsByCourseId(Long courseId);

    /**
     * @param teacherIds
     * @return
     */
    List<Long> getCourseIdsByteacherIds(Collection<Long> teacherIds);

    /**
     * 统计课程老师数
     * 
     * @param courseIds
     * @return
     */
    Map<Long, Integer> getTeacherCount(Collection<Long> courseIds);

    /**
     * 获取老师课程id
     * 
     * @param teacherId
     * @param pageDto
     * @return
     */
    List<Long> getTeacherCourseIds(Long teacherId, PageDto pageDto);

    List<Long> getOrgTeacherCourseIds(Long orgId, Long userId);

    /**
     * @param needUpdateToCanSeeUserIds
     * @param status
     */
    void updateStatusWithUserIds(Set<Long> needUpdateToCanSeeUserIds, int status);

}
