package com.baijia.tianxiao.dal.constant;


/**
 * 计费类型
 * Author: hanlaijin Date: 16/11/14 下午3:58
 */
public enum ChargeType {
    BY_OTHER(-1,"未知"), // 历史数据默认未知类型
    BY_PERIODS(1,"按期"), // 按期
    BY_CLASSHOUR(2,"按课时"), // 按课时
    ;
    private Integer code;
    private String label;

    ChargeType(int code,String label) {
        this.code = code;
        this.label = label;
    }

    public Integer getCode() {
        return code;
    }
	public String getLabel() {
		return label;
	}
	
	
	public static ChargeType getByCode(int code){
    	for (ChargeType p : values()) {
            if(p.getCode() == code){
            	return p;
            }
        }
    	return null;
    }


    public static boolean chargeByPeriods(int chargeType, int chargeUnit) {
        return chargeType == ChargeType.BY_PERIODS.getCode();
    }

    public static boolean chargeByClassHour(int chargeType, int chargeUnit) {
        return chargeType == ChargeType.BY_CLASSHOUR.getCode() && chargeUnit != ChargeUnit.BY_TIMES.getCode();
    }

    public static boolean chargeByTimes(int chargeType, int chargeUnit) {
        return chargeType == ChargeType.BY_CLASSHOUR.getCode() && chargeUnit == ChargeUnit.BY_TIMES.getCode();
    }



}