/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.user.dao.impl;


import com.baijia.tianxiao.dal.user.dao.TeacherModifiedDao;
import com.baijia.tianxiao.dal.user.po.TeacherModified;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

@Repository("teacherModifiedDao")
@Slf4j
public class TeacherModifiedDaoImpl extends JdbcTemplateDaoSupport<TeacherModified> implements TeacherModifiedDao {

    public TeacherModifiedDaoImpl() {
        super(TeacherModified.class);
    }

    @Override
    public TeacherModified getByUserId(@NonNull Long userId, String... queryProp) {
        SingleSqlBuilder<TeacherModified> builder = createSqlBuilder();
        builder.select(queryProp);
        builder.eq("userId", userId);
        return uniqueResult(builder);
    }


    @Override
    public void refreshCdbTeacherModified(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update cdb.teacher_modified set organization_id =null,updated_at=now() where id > :id and  organization_id = :orgId");
        java.util.Map param = com.google.common.collect.Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), param);
    }


}
