package com.baijia.tianxiao.dal.constant;

/**
 * Created by wengshengli on 2017/5/9.
 * 计费模式
 */
public enum ChargeMode {
    BY_OTHER(-1, "未知"),      //历史数据默认未知类型
    BY_TIMES(1, "按次"), // 按次
    BY_HOUR(2, "按课时"); // 按课时

    private Integer code;
    private String desc;

    ChargeMode(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ChargeMode getChargeMode(ChargeUnit chargeUnit) {
        if (ChargeUnit.isByTime(chargeUnit.getCode())) {
            return BY_HOUR;
        } else if (ChargeUnit.isByTimes(chargeUnit.getCode())) {
            return BY_TIMES;
        }
        return BY_OTHER;
    }

    public static ChargeMode getByCharegeUnit(int chargeUnit) {
        if (ChargeUnit.isByTime(chargeUnit)) {
            return BY_HOUR;
        } else if (ChargeUnit.isByTimes(chargeUnit)) {
            return BY_TIMES;
        }
        return BY_OTHER;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
