
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.storage.dao.impl;

import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;


/**
 * @title StorageDaoImpl
 * @desc TODO 
 * @author zhangbing
 * @date 2015年12月8日
 * @version 1.0
 */
@Repository("storageDao")
public class StorageDaoImpl extends JdbcTemplateDaoSupport<Storage> implements StorageDao {

    public StorageDaoImpl() {
        super(Storage.class);
    }

    /**
     * 批量获取图片信息
     */
    @Override
    public Map<Long, Storage> getStorageMapByIds(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }

        List<Storage> storages = getByIds(ids);

        if (CollectionUtils.isEmpty(storages)) {
            return Collections.emptyMap();
        }
        Map<Long, Storage> result = Maps.newHashMap();
        for (Storage storage : storages) {
            result.put(storage.getId().longValue(), storage);
        }
        return result;
    }

    @Override
    public Storage getStorageById(Long id) {
        SingleSqlBuilder<Storage> builder = createSqlBuilder();
        builder.eq("id", id);
        
        return this.uniqueResult(builder);
    }
}

    