package com.baijia.tianxiao.dal.org.po;

import java.sql.Blob;
import java.util.Date;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @author shizuwei
 * @version 1.0
 * @title OrgCourse
 * @desc cdb.org_course
 * @date 2015年12月3日
 */
@Entity
@Table(catalog = "cdb", name = "org_course")
@Data
public class OrgCourse {

    @Id
    @GeneratedValue
    private Long id;

    @Column(name = "number")
    private Long number;

    @Column(name = "branch_id")
    private Long branchId;

    @Column(name = "room_id")
    private Long roomId;

    @Column(name = "layout_id")
    private Long layoutId;

    @Column(name = "clsfy_id")
    private Long clsfyId;

    @Column(name = "organization_number")
    private Long orgNumber;

    @Column(name = "cover")
    private Integer cover;

    @Column(name = "lesson_way")
    private Integer lessonWay;

    /**
     * 班课包含的subject的id
     */
    @Column(name = "subject_id")
    private Integer subjectId;
    /**
     * 价格
     */
    @Column(name = "price")
    private Double price;

    @Column(name = "name")
    private String name;

    /**
     * 课程开始时间
     */
    @Column(name = "begin_time")
    private Date beginTime;

    /**
     * 课程结束时间
     */
    @Column(name = "end_time")
    private Date endTime;

    /**
     * 最大学生数
     */
    @Column(name = "max_student")
    private Integer maxStudent;

    /**
     * 课节数
     */
    @Column(name = "freq")
    private Integer freq;

    /**
     * 班课状态.0=招生中,1=已下架
     */
    @Column(name = "status")
    private Integer status;

    @Column
    private Date createTime;

    @Column(name = "rank")//星级排名
    private Integer rank;

    @Column(name = "extend_status")//推广状态
    private Integer extendStatus;

    @Column(name = "transform")
    private Integer transform;

    @Column(name = "page_view")
    private Integer pageView;


    @Column
    private String color;

    @Column(name = "address")
    private String address;

    @Column(name = "lesson_summary")
    private String lessonSummary;

    @Column(name = "last_set_time")
    private Date lastSetTime;

    @Column(name = "verify_status")
    private Integer verifyStatus;


    // 经纬度以逗号分割
    @Column(name = "offline_poi")
    private String offlinePoi;

    // 课程简介 
    @Column(name = "introduction")
    private Blob introduction;

    //0正常，1删除
    @Column(name = "is_del")
    private Integer isDel;

    @Column(name = "cascade_id")
    private Integer cascadeId;

}