package com.baijia.tianxiao.dal.org.dao.impl;

import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.dao.OrgPVDao;
import com.baijia.tianxiao.dal.org.po.OrgPV;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Repository
public class OrgPVDaoImpl  extends JdbcTemplateDaoSupport<OrgPV> implements OrgPVDao {

    public OrgPVDaoImpl() {
        super(OrgPV.class);
    }

    @Override
    public int getOrgTotalPV(Long orgNumber) {
        SingleSqlBuilder<OrgPV> builder = createSqlBuilder();
        builder.sum("view");
        builder.eq("userNumber", orgNumber);
        Integer count = queryForObject(builder, Integer.class);
        if(count == null){
            return 0;
        }
        return count;
    }

    @Override
    public int getOrgPeroidPv(Long orgNumber, Date startDate, Date endDate) {
        SingleSqlBuilder<OrgPV> builder = createSqlBuilder();
        builder.sum("view");
        builder.eq("userNumber", orgNumber);
        builder.ge("created_at", startDate.getTime());
        builder.le("created_at", endDate.getTime());
        Integer count =  queryForObject(builder, Integer.class);
        if(count == null){
            return 0;
        }
        return count;
    }

    @Override
    public List<OrgPV> getOrgPv(Long orgNumber, Date startDate, Date endDate) {
        SingleSqlBuilder<OrgPV> builder = createSqlBuilder();
        builder.eq("userNumber", orgNumber);
        builder.ge("date", startDate);
        builder.le("date", endDate);
        return queryList(builder, OrgPV.class);
    }
    
    

}
