package com.baijia.tianxiao.dal.org.dao.impl;

import java.util.Date;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.dao.OrgCourseAccessDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseAccess;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Repository
public class OrgCourseAccessDaoImpl extends JdbcTemplateDaoSupport<OrgCourseAccess> implements OrgCourseAccessDao {

    public OrgCourseAccessDaoImpl() {
        super(OrgCourseAccess.class);
    }

    @Override
    public int getCourseTotalPv(long courseNum) {
        SingleSqlBuilder<OrgCourseAccess> builder = createSqlBuilder();
        builder.sum("pv");
        builder.eq("number", courseNum);
        Integer count = queryForObject(builder, Integer.class);
        if(count == null){
            return 0;
        }
        return count;
    }

    @Override
    public int getCoursePeroidPv(long courseNum, Date startDate, Date endDate) {
        SingleSqlBuilder<OrgCourseAccess> builder = createSqlBuilder();
        builder.sum("pv");
        builder.eq("number", courseNum);
        builder.ge("date", startDate);
        builder.le("date", endDate);
        Integer count = queryForObject(builder, Integer.class);
        if(count == null){
            return 0;
        }
        return count;
    }

}
