
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.google.common.collect.Maps;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.course.po.Subject;
import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @author shanyu
 * @version 1.0
 * @title AreaDaoImpl
 * @desc TODO
 * @date 2016年1月22日
 */
@Repository
public class AreaDaoImpl extends JdbcTemplateDaoSupport<Area> implements AreaDao {

    public AreaDaoImpl() {
        super(Area.class);
    }


    @Override
    public List<Area> getBylevel(int id, long mask, int level) {
        Map map = Maps.newHashMap();
        map.put("mask", mask);
        map.put("level", level);
        map.put("id", id);

        StringBuilder sb = new StringBuilder("select id,name,level,bname from cdb.area where id&:mask = :id and level = :level order by display_order desc");
        return this.getNamedJdbcTemplate().query(sb.toString(), map, new RowMapper<Area>() {
            @Override
            public Area mapRow(ResultSet resultSet, int i) throws SQLException {

                Area area = new Area();
                area.setId(resultSet.getInt("id"));
                area.setName(resultSet.getString("name"));
                area.setBname(resultSet.getString("bname"));
                area.setLevel(resultSet.getInt("level"));
                return area;
            }
        });
    }

    @Override
    public List<Area> getBylevel(int level) {
        SingleSqlBuilder<Area> builder = createSqlBuilder();
        builder.eq("level", level);
        builder.desc("displayOrder");

        return queryList(builder);
    }

    /**
     * 根据手输地址获取地域ID
     * @param name 省/市/区
     * @param level 0/1/2/3/4/5
     */
    @Override
    public List<Area> getAreaByBname(String name, int level) {
        SingleSqlBuilder<Area> builder = createSqlBuilder();
        builder.eq("level", level);
        builder.add(Expressions.or(Expressions.like("name", name, MatchMode.START), Expressions.like("bname", name, MatchMode.START)));
        builder.desc("displayOrder");
        return queryList(builder);
    }
}
