/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import lombok.Data;

/**
 * @author shizuwei
 * @version 1.0
 * @title OrgCourseDao
 * @desc TODO
 * @date 2015年12月4日
 */

public interface OrgCourseDao extends CommonDao<OrgCourse> {

    /**
     * 根据机构number获取机构的课程列表
     *
     * @param orgNumber
     * @param status    课程状态,不传查询全部
     * @return
     */
    List<OrgCourse> getCoursesByOrgNumber(Long orgNumber, String key, Integer status, PageDto page, String... queryProp);

    /**
     * 根据机构number获取机构的课程列表
     *
     * @param orgNumber
     * @param key
     * @param status
     * @param startTime
     * @param endTime
     * @param page
     * @param queryProp
     * @return
     */
    List<OrgCourse> getCourseList(Long orgNumber, Collection<Long> courseIds, String key, Integer status,
                                  Date startTime, Date endTime, PageDto page, String... queryProp);

    List<OrgCourse> getCourseList(Collection<Long> courseIds, Long orgNumber, PageDto page, String... queryProp);

    /**
     * 根据机构number和课程名称查询课程ID
     *
     * @param orgNumber
     * @param name
     * @param status
     * @return
     */
    List<Long> getCourseIdsByOrgNumberAndCourseName(Long orgNumber, String name, Integer status);

    /**
     * 快速签到根据名称搜素
     *
     * @param orgNumber
     * @param name
     * @param status
     * @param courseIds
     * @param limit
     * @return
     */
    public List<OrgCourse> getCourseByOrgNumberAndCourseName(Long orgNumber, String name, Integer status, Collection<Long> courseIds, Integer limit);
    
    /**
     * 根据课程ID查找课程
     *
     * @param orgCourseId
     * @return
     */
    OrgCourse getByCourseId(Long orgCourseId, String... queryProp);

    /**
     * 获取课程名
     *
     * @param orgCourseId
     * @return
     */
    String getCourseNameById(Long orgCourseId);

    /**
     * 根据课程Number查找课程
     *
     * @param orgCourseNumber
     * @return
     */
    OrgCourse getByCourseNumber(Long orgCourseNumber, String... queryProp);

    /**
     * 获取id和PO的映射关系
     *
     * @param courseIds
     * @return
     */
    Map<Long, OrgCourse> getOrgCourseMap(Collection<Long> courseIds);

    /**
     * 按courseIds查询，并且保持courseIds的顺序
     *
     * @param courseIds
     * @param limit
     * @return
     */
    List<OrgCourse> getByIdsOrderByIn(Collection<Long> courseIds, Integer limit);

    /**
     * 根据3810课程状态查询机构下课程数
     *
     * @param orgNumber
     * @param status
     * @return
     */
    int getValidOrgCourseCount(Integer orgNumber);

    /**
     * 获取ids集合下未下架的课程数
     *
     * @param orgNumber
     * @param ids
     * @return
     */
    int getValidOrgCourseCount(Integer orgNumber, Collection<Long> ids);

    Map<Long, String> getCourseNameMap(Collection<Long> courseIds);

    Map<Integer, Integer> allCourseOrgIdMap();

    /**
     * 根据课程number和机构number获取课程
     *
     * @param orgNum
     * @param courseNumber
     * @param queryProp
     * @return
     */
    OrgCourse getCourseByCourseNumberAndOrgNumber(Long orgNum, Long courseNumber, String... queryProp);

    /**
     * 获取机构3810课程类目ids
     *
     * @param orgNumber
     * @return
     */
    List<Integer> getOrgCourseSubjectIds(Integer orgNumber);

    /**
     * 根据机构Number获取课程number
     *
     * @param orgNumber
     * @return
     */
    List<Long> getCourseNumberByOrg(Long orgNumber);

    /**
     * 根据课程number和机构number获取课程
     *
     * @return
     */
    List<Long> getCourseIdsByCourseNumberAndOrgNumber(Long orgNumber, Collection<Long> courseNumbers);

    /**
     * 获取机构3810课程
     *
     * @param orgNumber      机构number
     * @return
     */
    List<OrgCourse> getAndFilterOrgCourse(Integer orgNumber, Collection<Long> excludeIds, PageDto pageDto);

    /**
     * 获取机构3810课程
     *
     * @param orgNumber      机构number
     * @return
     */
    List<OrgCourse> getAndFilterOrgCourseByIn(Integer orgNumber, Collection<Long> includeIds, PageDto pageDto);

    /**
     * 获取机构课程
     *
     * @param orgNumber
     * @param includeIds
     * @param status
     * @param pageDto
     * @return
     */
    public List<OrgCourse> getAndFilterOrgCourseByIn(Integer orgNumber, Collection<Long> includeIds, Integer status,
                                                     PageDto pageDto);

    /**
     * 更改课程颜色值
     *
     * @param courseId
     * @param color
     */
    void changeCourseColor(Integer orgNumber, Long courseId, String color);

    /**
     * 更改课程颜色值
     *
     */
    void changeCourseColor(Collection<OrgCourse> courses);

    /*
     * 获取机构3810课程，按照是否推广进行排序
     * 
     * @param orgNumber
     * 
     * @return
     */
    List<OrgCourse> getVisualOrgCourseByOrgNumber(Integer orgNumber, String subjectIds, int orderType);

    /**
     * 根据课程number获取详细信息
     *
     * @param orgNumber
     * @param courseNum
     * @return
     */
    OrgCourse getOrgCourse(Integer orgNumber, Long courseNum);

    int getAdvertiseCourseCount(Integer orgNumber);

    int getMaxId();

    public List<String> getBlobString(Long orgNumber, Long courseNumber);

    List<Long> getCourseIds(Long orgNumber, Integer status);

    List<OrgCourse> getCourseList(Long orgNumber, Collection<Long> courseIds, OrgCourseListParam param,
                                  String... queryProp);

    List<Long> getCourseList(Long orgNumber, Collection<Long> courseIds, String key, Integer status);

    List<OrgCourse> getCoursesByIds(Long orgNumber, Collection<Long> courseIds, String key, Integer status);

    List<Long> getCourseList(Long orgNumber, Collection<Long> courseIds, Double lPrice, Double hPrice,
                             Collection<Long> subjectIds, String key, Integer status);

    @Data
    public static class OrgCourseListParam {
        private String key;
        private Integer status;
        private Date startTime;
        private Date endTime;
        /**
         * price,name,beginTime,createTime
         */
        private String orderField;
        private String orderType;
        private Integer isDel = 0;
        private PageDto page;
        private Expression queryCondition;
        private Integer cascadeId;
    }

    void repairNumber();

    /**
     * 查询所有机构对应的微课数
     */
    public Map<Integer, Integer> getCourseTotal(Date startTime, Date endTime, List<Integer> TianxiaoOrgNumbers);

    /**
     * 按日期查询微客数量
     */
    public Map<String, Integer> getCourseTotalMap(Date startTime, Date endTime, List<Integer> TianxiaoOrgNumbers);

    void refreshOrgCourse(Long orgId, Long id);

    /**
     * 根据机构orgNumbres获取每个机构与其微课列表对应关系
     */
    public List<OrgCourse> getOrgCourseList(Collection<Integer> orgNumbers);

    List<OrgCourse> getNormalCourseList(Collection<Long> courseIds, String... queryProp);

    List<OrgCourse> getCourseByCasCadeIds(Integer orgNumber, List<Integer> casCadeId, String... queryProp);

    public List<Long> getCourseIdsByCascadeId(Integer cascadeId);

    /**
     * 根据课程number、班主任id和机构number获取课程
     *
     * @param cascadeId
     * @return
     */
    public OrgCourse getOrgCourse(Integer orgNumber, Long courseNum, Integer cascadeId);

    public List<OrgCourse> getCourseList(Integer cascadeId, Long orgNumber, Collection<Long> courseIds, String key, Integer status,
        Date startTime, Date endTime, PageDto page, String...queryProp);

    public void batchUpdateHeadTeacher(Integer orgNumber,Integer OldCascadeId,Integer newCascadeId);

    /**
     * @param orgNumber
     * @param key
     * @param status
     * @param page
     * @return
     */
        
    List<OrgCourse> getCoursesByOrgNumberAndName(Long orgNumber, String key, Integer status, PageDto page);

    /**
     * @param orgId
     * @param filterIds
     * @param allCourse
     * @param pageDto
     * @return
     */
    List<OrgCourse> searchCourses(Long number, Set<Long> filterIds, boolean allCourse, PageDto pageDto);
    
    List<OrgCourse> getCoursesByOrgNumberAndNames(Long orgNumber, List<String> courseNames, Integer status, PageDto page);
    
    
}
