package com.baijia.tianxiao.dal.course.po;

import java.util.Date;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * 机构班课
 * @title TeacherClassCourse
 * @desc TODO 
 * @author zhangbing
 * @date 2015年12月5日
 * @version 1.0
 */
@Entity(name = "teacher_class_course")
@Data
@Table(catalog = "cdb")
public class TeacherClassCourse {

    @Id
    @GeneratedValue
    private Long id;

    @Column(name = "number")
    private Long number;// 唯一编号,暴露给对外接口

    @Column(name = "user_id")
    private Long userid;

    @Column(name = "subject_id")
    private Long subjectid;

    @Column(name = "name")
    private String name;

    @Column(name = "lesson_way")
    private Integer lessonWay;

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    @Column(name = "begin_time")
    private Date beginTime;

    @Column(name = "end_time")
    private Date endTime;

    @Column(name = "course_len")
    private Integer courseLen;

    @Column(name = "price")
    private Double price;

    @Column(name = "max_student")
    private Integer maxStudent;

    @Column(name = "address")
    private String address;

    @Column(name = "student_desc")
    private String studentDesc;

    @Column(name = "status")
    private Integer status;

    @Column(name = "verify_status")
    private Integer verifyStatus;

    @Column(name = "reason")
    private String reason;

    @Column(name = "reason_text")
    private String reasonText;

    @Column(name = "area_id")
    private Long areaid;

    @Column(name = "use_regular_addr")
    private Integer useRegularAddr;// 1-使用常用地址，2-不使用
    
    @Column(name = "is_complete")
    private Integer isComplete;
    
    @Column(name = "organization_number")
    private Integer organizationNumber;
    
    @Column(name = "chaban_flag")
    private Integer chabanFlag;
    
    @Column(name = "original_price")
    private Double originalPrice;
    
    @Column(name = "cover")
    private Long cover;
    
    @Column(name = "open_status")
    private Integer openStatus;
    
    @Column(name = "rank")
    private Integer rank;
    
    @Column(name = "extend_status")//推广状态
    private Integer extendStatus;
    
    @Column(name = "page_view")
    private Integer pageView;
    
    @Column(name = "transform")
    private Integer transform;
    
    @Column(name = "arrangement")
    private String arrangement;
    
    @Column(name = "last_set_time")
    private Date lastSetTime;
    
    
}
