/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.course.dao.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.course.dao.ClassCourseScheduleDao;
import com.baijia.tianxiao.dal.course.po.ClassCourseSchedule;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.BatchQueryTemplate;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * @title ClassCourseScheduleImpl
 * @desc TODO
 * @author shanyu
 * @date 2015年12月7日
 * @version 1.0
 */
@Repository
public class ClassCourseScheduleImpl extends JdbcTemplateDaoSupport<ClassCourseSchedule>
    implements ClassCourseScheduleDao {

    @Override
    public Map<Long, Integer> getCourseTimeMap(Collection<Long> courseNumbers, Date time, Long orgNumber) {
        List<ClassCourseSchedule> list = getCoursseSchedule(courseNumbers, time, orgNumber, "courseNumber");
        Map<Long, Integer> result = Maps.newHashMap();
        for (ClassCourseSchedule classCourseSchedule : list) {
            if (!result.containsKey(classCourseSchedule.getCourseNumber())) {
                result.put(classCourseSchedule.getCourseNumber(), 0);
            }
            result.put(classCourseSchedule.getCourseNumber(), result.get(classCourseSchedule.getCourseNumber()) + 1);
        }
        return result;

    }

    @Override
    public List<ClassCourseSchedule> getCoursseSchedule(Collection<Long> courseNumbers, final Date time,
        final Long orgNumber, final String...queryProps) {
        if (CollectionUtils.isEmpty(courseNumbers)) {
            return Lists.newArrayList();
        }
        BatchQueryTemplate<Long, List<ClassCourseSchedule>> batchQueryTemplate = new ListBatchQueryTemplate<>();
        return batchQueryTemplate.batchQuery(courseNumbers, new BatchQueryCallback<Long, List<ClassCourseSchedule>>() {

            @Override
            public List<ClassCourseSchedule> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder<ClassCourseSchedule> builder = createSqlBuilder(queryProps);
                if (time != null) {
                    builder.le("endTime", time);
                }
                builder.eq("orgNumber", orgNumber);
                builder.in("courseNumber", querySet);
                return queryList(builder);
            }
        });
    }
}
