/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.course.dao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @author zhangbing
 * @version 1.0
 * @title TeacherClassCourseDao
 * @desc TODO
 * @date 2015年12月5日
 */

public interface TeacherClassCourseDao extends CommonDao<TeacherClassCourse> {

    int getVliadClassCourseCount(Integer orgNumber);

    int getCourseCountByTeacherId(Long teacherId);

    TeacherClassCourse getByCouseNumber(Long courseNumber);

    int getValidClassCourseCountByIds(Integer orgNumber, Collection<Long> ids);

    List<Integer> getOrgDistinctSubject(Integer orgNumber);

    List<TeacherClassCourse> getCoursesByNumbers(Collection<Long> numbers, Long orgNumber, String... queryProps);

    List<TeacherClassCourse> getOrgCourseList(Integer number, Collection<Long> excludeIds, PageDto pageDto);

    List<TeacherClassCourse> getOrgCourseListByIn(Integer number, Collection<Long> inludeIds, PageDto pageDto);

    List<TeacherClassCourse> getVisualTeacherCourseByOrgNumber(Integer orgNumber, String subjectIds,
                                                               String courseTypes, int orderType);


    Map<Long, TeacherClassCourse> getTeacherClassCourses(Collection<Long> ids);

    TeacherClassCourse getTeacherClassCourse(Integer orgNumber, Long courseNumber);

    int getAdvertiseCourseCount(Integer orgNumber);

    int getMaxId();

    List<String> getBlobString(Integer orgNumber, Long courseNumber);

}
