package com.baijia.tianxiao.dal.constant;

import com.google.common.collect.Maps;

import java.util.Map;

public enum ClassCourseStatus {
	NEW(1, "初始"),
	
	ENROLLING(2, "正在招生"),
	
	ENROLLED(3, "停止招生"),
	
	FULL(4, "报满"),
	
	TEACHING(5, "开课中"),
	
	END(6, "课程结束"),
	
	DELETE(7, "课程删除"),
	
	AUDIT(8, "审核中"),
	
	OUTTIME(11, "课程过期"),
	
	VOIDNESS(12, "已失效"),
	
	TERMINATION(13, "课程终止");
	
	private int state;
	
	private String label;
	
	private ClassCourseStatus(int state, String label) {
		this.state = state;
		this.label = label;
	}

	public int getState() {
		return state;
	}

	public void setState(int state) {
		this.state = state;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}
	
	private static Map<Integer, ClassCourseStatus> map = Maps.newHashMap();
	
	static{
	    for(ClassCourseStatus classCourseStatus : ClassCourseStatus.values()){
	        map.put(classCourseStatus.getState(), classCourseStatus);
	    }
	}
	
	public static ClassCourseStatus getClassCourseStatusByState(Integer state){
	    ClassCourseStatus classCourseStatus = map.get(state);
	    return classCourseStatus;
	}
}
