/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.user.dao.impl;

import com.baijia.tianxiao.dal.org.extractors.StatisticsExtractor;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="teacherDao")
public class TeacherDaoImpl
extends JdbcTemplateDaoSupport<Teacher>
implements TeacherDao {
    private static final Logger log = LoggerFactory.getLogger(TeacherDaoImpl.class);

    public TeacherDaoImpl() {
        super(Teacher.class);
    }

    @Override
    public Teacher getByUserId(@NonNull Long userId, String ... queryProp) {
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("userId", (Serializable)userId);
        return (Teacher)((Object)this.uniqueResult(builder));
    }

    @Override
    public Teacher getByNumber(Long userNumber, String ... queryProp) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("userNumber", userNumber);
        sql.append("SELECT u.mobile,t.realname realName,t.nickname nickName,t.user_id userId,t.avatar  from cdb.user u join cdb.teacher t on t.user_id = u.id ");
        sql.append("WHERE 1=1 AND ");
        sql.append("u.number = :userNumber limit 1");
        List list = this.getNamedJdbcTemplate().query(sql.toString(), params, (RowMapper)new RowMapper<Teacher>(){

            public Teacher mapRow(ResultSet resultSet, int i) throws SQLException {
                Teacher teacher = new Teacher();
                teacher.setMobile(resultSet.getString("mobile"));
                teacher.setRealName(resultSet.getString("realName"));
                teacher.setNickName("nickName");
                teacher.setUserId(resultSet.getLong("userId"));
                teacher.setAvatar(resultSet.getLong("avatar"));
                return teacher;
            }
        });
        if (list != null && list.size() > 0) {
            return (Teacher)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public List<Teacher> getByUserIds(Collection<Long> userIds, final String ... queryProp) {
        if (userIds == null || userIds.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List teachers = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Teacher>>(){

            public List<Teacher> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = TeacherDaoImpl.this.createSqlBuilder(queryProp);
                builder.in("userId", querySet);
                return TeacherDaoImpl.this.queryList(builder);
            }
        });
        return teachers;
    }

    @Override
    public Map<Long, String> getTeacherRealNameMap(@NonNull Collection<Long> teacherIds) {
        if (teacherIds == null) {
            throw new NullPointerException("teacherIds");
        }
        if (teacherIds.isEmpty()) {
            log.warn("teacher ids is empty.");
            return Collections.emptyMap();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List teachers = (List)queryTemplate.batchQuery(teacherIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Teacher>>(){

            public List<Teacher> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = TeacherDaoImpl.this.createSqlBuilder(new String[0]);
                builder.select("realName");
                builder.select("nickName");
                builder.select("userId");
                builder.in("userId", querySet);
                return TeacherDaoImpl.this.queryList(builder);
            }
        });
        if (CollectionUtils.isEmpty((Collection)teachers)) {
            return Collections.emptyMap();
        }
        HashMap teacherRealNameMap = Maps.newHashMap();
        for (Teacher teacher : teachers) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacher.getRealName()})) {
                teacherRealNameMap.put(teacher.getUserId(), teacher.getRealName());
                continue;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacher.getNickName()})) {
                teacherRealNameMap.put(teacher.getUserId(), teacher.getNickName());
                continue;
            }
            teacherRealNameMap.put(teacher.getUserId(), "\u533f\u540d");
        }
        return teacherRealNameMap;
    }

    @Override
    public List<Teacher> getTeachersByOrgId(Long orgId, PageDto page, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, List<Teacher>> getBranchTeachMap(Long orgId, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        List teachers = this.queryList(builder);
        return CollectorUtil.group((Collection)teachers, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher from) {
                return from.getBranchId();
            }
        });
    }

    @Override
    public Integer getTeachersCountByOrgId(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Teacher> searchTeacherByMobileAndName(Long orgId, String key, Integer limit) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key}), (Object)"search key can not be empty");
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT u.mobile,t.realname realName,t.nickname nickName,t.user_id userId,t.avatar  from cdb.user u join cdb.teacher t on t.user_id = u.id ");
        sql.append("WHERE 1=1 AND ");
        if (orgId != null) {
            sql.append(" t.organization_id=:orgId AND ");
            params.put("orgId", orgId);
        }
        sql.append("( u.mobile like :key or u.number like :key or t.realname like :key or t.nickname like :key )");
        if (limit != null && limit > 0) {
            sql.append(" LIMIT 0,:limit");
            params.put("limit", limit);
        }
        params.put("key", MatchMode.ANYWHERE.toMatchString(key));
        return this.getNamedJdbcTemplate().query(sql.toString(), params, (RowMapper)new BeanPropertyRowMapper(Teacher.class));
    }

    @Override
    public List<Teacher> getByTeacherIds(Collection<Long> teacherIds, final String ... queryProp) {
        if (teacherIds.isEmpty()) {
            log.warn("teacher ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(teacherIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Teacher>>(){

            public List<Teacher> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = TeacherDaoImpl.this.createSqlBuilder(queryProp);
                builder.in("userId", querySet);
                return TeacherDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<Teacher> getTeachers(Long orgId, Collection<Long> teacherIds, String key, Date startTime, Date endTime, Integer teacherStatus, PageDto page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder countSql = new StringBuilder();
        StringBuilder selectSql = new StringBuilder();
        StringBuilder fromSql = new StringBuilder();
        StringBuilder limitSql = new StringBuilder();
        countSql.append("SELECT count(u.id) ");
        selectSql.append("SELECT u.mobile,t.realname realName,t.nickname nickName,t.user_id userId,t.avatar,t.school_age schoolAge,t.created_at as createTime ");
        fromSql.append(" from yunying.org_teachers u join cdb.teacher t on t.user_id = u.user_id ");
        fromSql.append("WHERE 1=1  ");
        if (orgId != null) {
            fromSql.append(" AND u.org_id=:orgId  ");
            fromSql.append(" AND t.organization_id=:orgId");
            params.put("orgId", orgId);
        }
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            fromSql.append(" AND u.user_id in (:teacherIds)  ");
            params.put("teacherIds", teacherIds);
        }
        if (teacherStatus != null) {
            fromSql.append(" AND u.status=:teacherStatus ");
            params.put("teacherStatus", teacherStatus);
        }
        if (startTime != null && endTime != null) {
            fromSql.append(" AND (t.created_at BETWEEN :startTime AND :endTime) ");
            params.put("startTime", startTime);
            params.put("endTime", endTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            if (key.length() < 4 && StringUtils.isNumeric((CharSequence)key)) {
                fromSql.append(" AND ( t.realname like :key or t.nickname like :key) ");
            } else {
                fromSql.append(" AND ( u.mobile like :key or t.realname like :key or t.nickname like :key) ");
            }
            params.put("key", MatchMode.ANYWHERE.toMatchString(key.trim()));
        }
        fromSql.append(" ORDER BY t.created_at desc ");
        if (page != null) {
            limitSql.append(" LIMIT :begin,:limit");
            params.put("begin", page.firstNum());
            params.put("limit", page.getPageSize());
        }
        String countsql = countSql.append((CharSequence)fromSql).toString();
        String selectsql = selectSql.append((CharSequence)fromSql.append((CharSequence)limitSql)).toString();
        log.debug("query teacher sql:{},params:{}", (Object)selectsql, params);
        List teachers = this.getNamedJdbcTemplate().query(selectsql, params, (RowMapper)new BeanPropertyRowMapper(Teacher.class));
        if (page != null) {
            log.info("Query teacher debug sql:{},params:{}", (Object)countSql.toString(), params);
            int count = (Integer)this.getNamedJdbcTemplate().queryForObject(countsql, params, Integer.class);
            page.setCount(Integer.valueOf(count));
            page.setCurPageCount(Integer.valueOf(teachers.size()));
        }
        return teachers;
    }

    @Override
    public List<Teacher> getTeachers(Long orgId, Collection<Long> teacherIds, String key, Date startTime, Date endTime, PageDto page) {
        return this.getTeachers(orgId, teacherIds, key, startTime, endTime, null, page);
    }

    @Override
    public void refreshCdbTeacher(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update cdb.teacher set organization_id =null,updated_at=now() where id > :id and  organization_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public Map<Long, Integer> getPeriodOrgTeacher(Integer category, Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select count(1) as count,organization_id as org_id from cdb.teacher where organization_id in (:orgIds) ";
        if (category != null) {
            sql = sql + " and category = :category";
            param.put("category", category);
        }
        if (startDate != null && endDate != null) {
            sql = sql + " and created_at between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        sql = sql + " GROUP BY organization_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new StatisticsExtractor());
    }

    @Override
    public List<Teacher> fuzzyQueryByNameAndMobile(Long orgId, Collection<Long> teacherIds, String key) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u65e0\u6cd5\u83b7\u53d6\u673a\u6784\u4fe1\u606f");
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("SELECT u.mobile,t.realname realName,t.nickname nickName,t.user_id userId,t.avatar  from cdb.user u join cdb.teacher t on t.user_id = u.id ");
        sql.append("WHERE 1=1 ");
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            sql.append(" and u.id in (:teacherIds) ");
            params.put("teacherIds", teacherIds);
        }
        if (orgId != null && orgId > 0L) {
            sql.append(" and t.organization_id=:orgId ");
            params.put("orgId", orgId);
        }
        if (StringUtils.isNotBlank((CharSequence)key)) {
            sql.append("and ( u.mobile like :key or t.realname like :key )");
            params.put("key", MatchMode.ANYWHERE.toMatchString(key));
        }
        return this.getNamedJdbcTemplate().query(sql.toString(), params, (RowMapper)new BeanPropertyRowMapper(Teacher.class));
    }
}

