/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.user.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @author cxm
 * @version 1.0
 * @title UserDao
 * @desc TODO
 * @date 2015年9月8日
 */
public interface TeacherDao extends CommonDao<Teacher> {

    Teacher getByUserId(Long userId, String... queryProp);

    Teacher getByNumber(Long userNumber, String... queryProp);

    public List<Teacher> getByUserIds(Collection<Long> userIds, String... queryProp);

    public List<Teacher> getByTeacherIds(Collection<Long> teacherIds, String... queryProp);

    public Map<Long, String> getTeacherRealNameMap(Collection<Long> teacherIds);

    public List<Teacher> getTeachersByOrgId(Long orgId, PageDto page, final String... queryProp);

    public List<Teacher> getTeachers(Long orgId, Collection<Long> teacherIds, String key, Date startTime, Date endTime, PageDto page);

    /**
     *
     * @param orgId
     * @param teacherIds
     * @param key
     * @param startTime
     * @param endTime
     * @param teacherStatus  参考OrgTeacherStatus
     * @param page
     * @return
     */
    public List<Teacher> getTeachers(Long orgId, Collection<Long> teacherIds, String key, Date startTime, Date endTime,Integer teacherStatus, PageDto page);

    public Map<Long, List<Teacher>> getBranchTeachMap(Long orgId, String... queryProp);

    public Integer getTeachersCountByOrgId(Long orgId);

    /**
     * @param orgId
     * @param key
     * @param limit
     * @return
     */
    List<Teacher> searchTeacherByMobileAndName(Long orgId, String key, Integer limit);

    void refreshCdbTeacher(Long orgId, Long id);

    /**
     * @param category 老师类型 1 正式老师 2 大学生 3 其他，如果为null是不限类别
     * @return
     */
    public Map<Long,Integer> getPeriodOrgTeacher(Integer category, Date startDate, Date endDate, List<Long> TianxiaoOrgIds);
    
    /**
     * 根据用户搜索条件模糊匹配老师手机号和realname
     * @param orgId
     * @param teacherIds
     * @param query
     * @return
     */
    public List<Teacher> fuzzyQueryByNameAndMobile(Long orgId, Collection<Long> teacherIds, String key);

}