/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.enums.CourseArrangedEnum;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.Data;

/**
 * @author shizuwei
 * @version 1.0
 * @title OrgCourseDao
 * @desc TODO
 * @date 2015年12月4日
 */

public interface OrgCourseDao extends CommonDao<OrgCourse> {

    /**
     * 根据机构number获取机构的课程列表
     *
     * @param orgNumber
     * @param status    课程状态,不传查询全部
     * @return
     */
    List<OrgCourse> getCoursesByOrgNumber(Long orgNumber, String key, Integer status,Integer isCourse,Integer isClass, Integer courseType,PageDto page,String... queryProp);

    /**
     * 根据机构number获取机构的课程列表
     *
     * @param orgNumber
     * @param key
     * @param status
     * @param startTime
     * @param endTime
     * @param page
     * @param queryProp
     * @return
     */
    List<OrgCourse> getCourseList(Long orgNumber, Collection<Long> courseIds, String key, Integer status,
                                  Date startTime, Date endTime, Integer isCourse,Integer isClass,Integer courseType,PageDto page, String... queryProp);

    List<OrgCourse> getCourseList(Collection<Long> courseIds, Long orgNumber, Integer isCourse,Integer isClass,Integer courseType,PageDto page, String... queryProp);

    /**
     * 根据机构number和课程名称查询课程ID
     *
     * @param orgNumber
     * @param name
     * @param status
     * @return
     */
    List<Long> getCourseIdsByOrgNumberAndCourseName(Long orgNumber, String name, Integer status,Integer isCourse,Integer isClass,Integer courseType);

    /**
     * 快速签到根据名称搜素
     *
     * @param orgNumber
     * @param name
     * @param status
     * @param courseIds
     * @param limit
     * @return
     */
    public List<OrgCourse> getCourseByOrgNumberAndCourseName(Long orgNumber, String name, Integer status, Collection<Long> courseIds, Integer isCourse,Integer isClass,Integer courseType,Integer limit);
    
    /**
     * 根据课程ID查找课程
     *
     * @param orgCourseId
     * @return
     */
    OrgCourse getByCourseId(Long orgCourseId, String... queryProp);

    /**
     * 获取课程名
     *
     * @param orgCourseId
     * @return
     */
    String getCourseNameById(Long orgCourseId);

    /**
     * 根据课程Number查找课程
     *
     * @param orgCourseNumber
     * @return
     */
    OrgCourse getByCourseNumber(Long orgCourseNumber, String... queryProp);

    /**
     * 获取id和PO的映射关系
     *
     * @param courseIds
     * @return
     */
    @Deprecated
    Map<Long, OrgCourse> getOrgCourseMap(Collection<Long> courseIds);

    /**
     * 按courseIds查询，并且保持courseIds的顺序
     *
     * @param courseIds
     * @param limit
     * @return
     */
    List<OrgCourse> getByIdsOrderByIn(Collection<Long> courseIds, Integer limit);

    /**
     * 根据3810课程状态查询机构下课程数
     *
     * @param orgNumber
     * @param status
     * @return
     */
    int getValidOrgCourseCount(Integer orgNumber,Integer isCourse,Integer isClass,Integer courseType);

    /**
     * 获取ids集合下未下架的课程数
     *
     * @param orgNumber
     * @param ids
     * @return
     */
    int getValidOrgCourseCount(Integer orgNumber, Collection<Long> ids);

    Map<Long, String> getCourseNameMap(Collection<Long> courseIds);

    Map<Integer, Integer> allCourseOrgIdMap();

    /**
     * 根据课程number和机构number获取课程
     *
     * @param orgNum
     * @param courseNumber
     * @param queryProp
     * @return
     */
    OrgCourse getCourseByCourseNumberAndOrgNumber(Long orgNum, Long courseNumber, String... queryProp);

    /**
     * 获取机构3810课程类目ids
     *
     * @param orgNumber
     * @return
     */
    List<Integer> getOrgCourseSubjectIds(Integer orgNumber,Integer isCourse,Integer isClass,Integer courseType);

    /**
     * 根据机构Number获取课程number
     *
     * @param orgNumber
     * @return
     */
    List<Long> getCourseNumberByOrg(Long orgNumber,Integer isCourse,Integer isClass,Integer courseType);

    /**
     * 根据课程number和机构number获取课程
     *
     * @return
     */
    List<Long> getCourseIdsByCourseNumberAndOrgNumber(Long orgNumber, Collection<Long> courseNumbers,Integer courseType);

    /**
     * 获取机构3810课程
     *
     * @param orgNumber      机构number
     * @param excludeNumbers 不包括的课程Ids
     * @return
     */
    List<OrgCourse> getAndFilterOrgCourse(Integer orgNumber, Collection<Long> excludeIds, Integer isCourse,Integer isClass,Integer courseType,PageDto pageDto);
 
    /**
     * 获取机构3810课程
     *
     * @param orgNumber      机构number
     * @param includeNumbers 不包括的课程
     * @return
     */
    List<OrgCourse> getAndFilterOrgCourseByIn(Integer orgNumber, Collection<Long> includeIds, Integer isCourse,Integer isClass,Integer courseType,PageDto pageDto);

    /**
     * 获取机构课程
     *
     * @param orgNumber
     * @param includeIds
     * @param status
     * @param pageDto
     * @return
     */
    public List<OrgCourse> getAndFilterOrgCourseByIn(Integer orgNumber, Collection<Long> includeIds, Integer status,Integer isCourse,Integer isClass,Integer courseType,
                                                     PageDto pageDto);

    /**
     * 更改课程颜色值
     *
     * @param orgId
     * @param courseId
     * @param color
     */
    void changeCourseColor(Integer orgNumber, Long courseId, String color);

    /**
     * 更改课程颜色值
     *
     * @param orgId
     * @param courseId
     * @param color
     */
    void changeCourseColor(Collection<OrgCourse> courses);

    /*
     * 获取机构3810课程，按照是否推广进行排序
     * 
     * @param orgNumber
     * 
     * @return
     */
    List<OrgCourse> getVisualOrgCourseByOrgNumber(Integer orgNumber, String subjectIds, int orderType,Integer isCourse,Integer isClass,Integer courseType);

    /**
     * 根据课程number获取详细信息
     *
     * @param orgNumber
     * @param courseNum
     * @return
     */
    OrgCourse getOrgCourse(Integer orgNumber, Long courseNum);

    int getAdvertiseCourseCount(Integer orgNumber,Integer isCourse,Integer isClass,Integer courseType);

    int getMaxId();

    public List<String> getBlobString(Long orgNumber, Long courseNumber);

    List<Long> getCourseIds(Long orgNumber, Integer status,Integer isCourse,Integer isClass,Integer courseType);

    List<OrgCourse> getCourseList(Long orgNumber, Collection<Long> courseIds, OrgCourseListParam param,
    		 String... queryProp);

    List<Long> getCourseList(Long orgNumber, Collection<Long> courseIds, String key, Integer status,Integer isCourse,Integer isClass,Integer courseType);

    List<OrgCourse> getCoursesByCascadeIds(Long orgNumber, Collection<Long> courseIds, String key, Integer status,Integer isCourse,Integer isClass,Integer courseType);

    List<Long> getCourseList(Long orgNumber, Collection<Long> courseIds, Double lPrice, Double hPrice,
                             Collection<Long> subjectIds, String key, Integer status,Integer isCourse,Integer isClass,Integer courseType,Integer chargeType);

    List<OrgCourse> getValidClassCourseCountsByIds(Integer number, List<Integer> orgCourseIds);

    @Data
    public static class OrgCourseListParam {
        private String key;
        private Integer status;
        private Date startTime;
        private Date endTime;

        /**
         *CourseArrangedEnum
         */
        private Integer arranged;

        private Integer isCourse;
        private Integer isClass;
        private Integer courseType;
        private Integer chargeType;
        /**
         * price,name,beginTime,createTime
         */
        private String orderField;
        private String orderType;
        private Integer isDel = 0;
        private PageDto page;
        private Expression queryCondition;
        private Integer cascadeId;
    }

    void repairNumber();

    /**
     * 查询所有机构对应的微课数
     */
    public Map<Integer, Integer> getCourseTotal(Date startTime, Date endTime, List<Integer> TianxiaoOrgNumbers,Integer isCourse,Integer isClass,Integer courseType);

    /**
     * 按日期查询微客数量
     */
    public Map<String, Integer> getCourseTotalMap(Date startTime, Date endTime, List<Integer> TianxiaoOrgNumbers,Integer isCourse,Integer isClass,Integer courseType);

    void refreshOrgCourse(Long orgId, Long id);

    /**
     * 根据机构orgNumbres获取每个机构与其微课列表对应关系
     */
    public List<OrgCourse> getOrgCourseList(Collection<Integer> orgNumbers,Integer isCourse,Integer isClass,Integer courseType);

    List<OrgCourse> getNormalCourseList(Collection<Long> courseIds, String... queryProp);

    List<OrgCourse> getCourseByCasCadeIds(Integer orgNumber, List<Integer> casCadeId, Integer isCourse,Integer isClass,Integer courseType,String... queryProp);

    public List<Long> getCourseIdsByCascadeId(Integer cascadeId,Integer isCourse,Integer isClass,Integer courseType);

    /**
     * 根据课程number、班主任id和机构number获取课程
     *
     * @param cascadeId
     * @return
     */
    public OrgCourse getOrgCourse(Integer orgNumber, Long courseNum, Integer cascadeId);

    public List<OrgCourse> getCourseList(Integer cascadeId, Long orgNumber, Collection<Long> courseIds, String key, Integer status,
        Date startTime, Date endTime, Integer isCourse,Integer isClass,Integer courseType,PageDto page, String...queryProp);

    public void batchUpdateHeadTeacher(Integer orgNumber,Integer OldCascadeId,Integer newCascadeId);

    /**
     * @param orgNumber
     * @param key
     * @param status
     * @param page
     * @return
     */
        
    List<OrgCourse> getCoursesByOrgNumberAndName(Long orgNumber, String key, Integer status,Integer isCourse,Integer isClass,Integer courseType, PageDto page);

    /**
     * @param orgId
     * @param filterIds
     * @param allCourse
     * @param pageDto
     * @return
     */
    List<OrgCourse> searchCourses(Long number, Set<Long> filterIds, boolean allCourse,Integer isCourse,Integer isClass, Integer courseType,PageDto pageDto);
    
    List<OrgCourse> getCoursesByOrgNumberAndNames(Long orgNumber, List<String> courseNames, Integer status, Integer isCourse,Integer isClass,Integer courseType,PageDto page);
    
    List<OrgCourse> fuzzyQuery(Integer orgNumber, String courseName, Collection<Long> courseIds, PageDto pageDto);
    /**
     * 根据课程名称模糊匹配
     * @param orgId
     * @param courseName
     * @param type : 检索类型 0 ： 课程  1 ：班级
     * @return
     */
    List<OrgCourse> fuzzyQueryByCourseType(Integer orgNumber, String courseName, Collection<Long> courseIds, Integer type, PageDto pageDto);
    
    public List<OrgCourse> getCoursesByParentIds(Long orgNumber, List<Long> parentIds);


    public List<Long> getClassIdsByParentId(Long parentId);

    /**
     * 更新班级结课状态
     * 
     * @param id
     * @param isFinish
     */
        
    public void updateFinish(Long id,Integer isFinish);

    public int getAllCourseCountByOrg(Long orgNumber);
    
    /**
     * 获取根据courseNumbers获取机构课程
     */
    public List<OrgCourse> getOrgCourseList(Long orgNumber, Collection<Long> courseNumbers);
}
