/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.util;

import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AreaUtils {
    @Autowired
    private AreaDao areaDao;
    private static final Map<Integer, Area> cache = new HashMap<Integer, Area>();
    private static final Map<Integer, List<Area>> subCache = Maps.newHashMap();
    private static final Map<String, Map<String, Object>> cascadeCache = Maps.newHashMap();

    public void init() {
        this.load();
    }

    private void load() {
        List areas = this.areaDao.getAll(new String[]{"id", "name", "bname", "level"});
        ArrayList provinces = Lists.newArrayList();
        Long parentMask = AreaLevel.PROVINCE.mask;
        if (CollectionUtils.isNotEmpty((Collection)areas)) {
            for (Area area : areas) {
                cache.put(area.getId(), area);
                if (area.getLevel() == 1) {
                    provinces.add(area);
                    continue;
                }
                if (area.getLevel() != 2) continue;
                Integer areaId = area.getId();
                Integer parentId = parentMask.intValue() & areaId;
                if (subCache.containsKey(parentId)) {
                    subCache.get(parentId).add(area);
                    continue;
                }
                ArrayList set = Lists.newArrayList();
                set.add(area);
                subCache.put(parentId, set);
            }
        }
    }

    public static String getAreaNameByCode(Integer code_id, AreaLevel level) {
        if (code_id == null) {
            return "";
        }
        if (level == null) {
            Area area = cache.get(code_id);
            if (area == null) {
                return "";
            }
            return area.getName();
        }
        switch (level) {
            case COUNTRY: 
            case PROVINCE: 
            case CITY: 
            case COUNTY: 
            case REGION: 
            case TRANSPORTATION: {
                return AreaUtils.getAreaName(code_id, level.getMask().intValue());
            }
        }
        return AreaUtils.getAreaName(code_id, level.getMask().intValue());
    }

    public static Map<String, String> getAreaNameByCode(Integer code_id) {
        HashMap<String, String> map = new HashMap<String, String>();
        Area area = null;
        if (code_id != null && (area = cache.get(code_id)) != null) {
            int level = area.getLevel();
            if (level >= AreaLevel.PROVINCE.ordinal()) {
                map.put("province", AreaUtils.getAreaName(code_id, AreaLevel.PROVINCE.getMask().intValue()));
            }
            if (level >= AreaLevel.CITY.ordinal()) {
                map.put("city", AreaUtils.getAreaName(code_id, AreaLevel.CITY.getMask().intValue()));
            }
            if (level >= AreaLevel.COUNTY.ordinal()) {
                map.put("county", AreaUtils.getAreaName(code_id, AreaLevel.COUNTY.getMask().intValue()));
            }
        }
        return map;
    }

    private static String getAreaName(Integer code_id, Integer level_mask) {
        Area area = cache.get(code_id & level_mask);
        if (area == null) {
            return "";
        }
        return area.getName();
    }

    public static Integer getAreaIdBySubId(Integer sub_code_id, Integer level_mask) {
        return sub_code_id & level_mask;
    }

    public static String getAreaStrByCode(Integer code_id) {
        if (code_id == null) {
            return "";
        }
        Area area = cache.get(code_id);
        if (area == null) {
            return "";
        }
        int level = area.getLevel();
        if (level < 0) {
            return area.getName();
        }
        if (level > 3) {
            level = 3;
        }
        ArrayList<String> areas = new ArrayList<String>(level + 1);
        String name = null;
        for (int i = 0; i <= level; ++i) {
            name = AreaUtils.getAreaName(code_id, AreaLevel.valueOf(i).getMask().intValue());
            if (areas.contains(name)) continue;
            areas.add(name);
        }
        name = area.getName();
        if (!areas.contains(name)) {
            areas.add(name);
        }
        StringBuilder result = new StringBuilder();
        for (String s : areas) {
            result.append("-").append(s);
        }
        result.substring(1);
        return result.toString();
    }

    public static List<Area> getAreaList(Integer key) {
        return subCache.get(key);
    }

    public static String getAreaName(Integer areaId) {
        Area area = cache.get(areaId);
        if (area != null) {
            return area.getBname();
        }
        return "";
    }

    public void cascadeCache() {
        List<Area> provinces = this.areaDao.getBylevel(AreaLevel.PROVINCE.ordinal());
        if (CollectionUtils.isNotEmpty(provinces)) {
            for (Area province : provinces) {
                int provinceId = province.getId();
                String provinceName = province.getName();
                List<Area> cities = this.areaDao.getBylevel(provinceId, AreaLevel.PROVINCE.mask, AreaLevel.CITY.ordinal());
                HashMap cityCache = Maps.newHashMap();
                HashMap countyCache = null;
                if (CollectionUtils.isNotEmpty(cities)) {
                    for (Area city : cities) {
                        int cityId = city.getId();
                        String cityName = city.getName();
                        List<Area> counties = this.areaDao.getBylevel(cityId, AreaLevel.CITY.mask, AreaLevel.COUNTY.ordinal());
                        countyCache = Maps.newHashMap();
                        for (Area county : counties) {
                            int countyId = county.getId();
                            String name = county.getName();
                            HashMap idCache = Maps.newHashMap();
                            idCache.put("id", countyId);
                            countyCache.put(name, idCache);
                        }
                        cityCache.put(cityName, countyCache);
                        this.getAreaIdCache(cityId, countyCache);
                    }
                }
                cascadeCache.put(provinceName, cityCache);
                this.getAreaIdCache(provinceId, cityCache);
            }
        }
    }

    public void getAreaIdCache(int id, Map<String, Object> idCache) {
        idCache.put("id", id);
    }

    public static Map<String, Map<String, Object>> getCascadeCache() {
        return cascadeCache;
    }

    public static enum AreaLevel {
        COUNTRY(0xFF00000000L),
        PROVINCE(0xFFFF000000L),
        CITY(0xFFFFFC0000L),
        COUNTY(0xFFFFFFFC00L),
        REGION(0xFFFFFFFFFFL),
        TRANSPORTATION(0xFFFFFFFFFFL);

        private static final AreaLevel[] values;
        private Long mask;

        private AreaLevel(Long mask) {
            this.mask = mask;
        }

        public Long getMask() {
            return this.mask;
        }

        public static AreaLevel valueOf(int pos) {
            if (pos < 0 || pos > values.length) {
                return null;
            }
            return values[pos];
        }

        static {
            values = AreaLevel.values();
        }
    }
}

